var gulp = require('gulp');
var del = require('del');
var gutil = require('gulp-util')
var plugins = require("gulp-load-plugins")({lazy:false});

var templateFolder = '../annot-server/templates/';
var templateFileDest = '../annot-server/templates/annotationclient.html';
var staticFolder = '../annot-server/static';

var clientBaseName = 'app';
var vendorBaseName = 'lib';

gulp.task('clean', function (cb) {
    del([
        templateFileDest,
        staticFolder + "/css/app*",
        staticFolder + "/js/app*",
        staticFolder + "/data/categories.json",
    ],{'force':true}, cb);
});

var scriptsSrc = ['!./app/**/*_test.js','./app/**/*.js'];

gulp.task('scripts', function(){
    //combine all js files of the app
    gulp.src(scriptsSrc)
        .pipe(plugins.jshint())
        .pipe(plugins.jshint.reporter('default'))
        .pipe(plugins.jshint.reporter('fail'))
        .pipe(plugins.concat(clientBaseName+'.js'))
        .pipe(gulp.dest(staticFolder+'/js'))
        .pipe(plugins.filesize())
        .pipe(plugins.uglify())
        .pipe(plugins.rename(clientBaseName+'.min.js'))
        .pipe(gulp.dest(staticFolder+'/js'))
        .pipe(plugins.filesize())
        .on('error', gutil.log);
});


gulp.task('css', function(){
    gulp.src('./app/**/*.css')
        .pipe(plugins.csslint({ 'box-sizing': false }))
        .pipe(plugins.csslint.reporter())
        .pipe(plugins.concat(clientBaseName+'.css'))
        .pipe(gulp.dest(staticFolder+'/css'))
        .pipe(plugins.filesize())
        .pipe(plugins.minifyCss({keepBreaks:true}))
        .pipe(plugins.rename(clientBaseName+'.min.css'))
        .pipe(gulp.dest(staticFolder+'/css'))
        .pipe(plugins.filesize());
});

var vendorJSsrc = [
  '!./bower_components/**/*.min.js',
  '!./bower_components/bootstrap/Gruntfile.js',
  '!./bower_components/bootstrap/grunt/*',
  '!./bower_components/bootstrap/js/*',
  '!./bower_components/jquery/src/**/*',
  '!./bower_components/angular-bootstrap/ui-bootstrap.js',
  './bower_components/jquery/dist/jquery.js',
  './bower_components/**/*.js'
];

gulp.task('vendorJS', function(){
    //concatenate vendor JS files
    gulp.src(vendorJSsrc)
        .pipe(plugins.concat('lib.js'))
        .pipe(gulp.dest(staticFolder+'/js'))
        .pipe(plugins.filesize())
        .pipe(plugins.uglify())
        .pipe(plugins.rename('lib.min.js'))
        .pipe(gulp.dest(staticFolder+'/js'))
        .pipe(plugins.filesize())
        .on('error', gutil.log);
});

gulp.task('vendorCSS', function(){
    //concatenate vendor CSS files
    gulp.src(['!./bower_components/**/*.min.css',
        './bower_components/**/*.css'])
        .pipe(plugins.concat(vendorBaseName+'.css'))
        .pipe(gulp.dest(staticFolder+'/css'))
        .pipe(plugins.filesize())
        .pipe(plugins.minifyCss({keepBreaks:true}))
        .pipe(plugins.rename(vendorBaseName+'.min.css'))
        .pipe(gulp.dest(staticFolder+'/css'))
        .pipe(plugins.filesize());
});

gulp.task('vendorFonts', function(){
    gulp.src(['./bower_components/**/fonts/*'])
        .pipe(plugins.flatten())
        .pipe(gulp.dest(staticFolder+'/css/fonts'));
});

gulp.task('copy-index', function() {
    gulp.src('./app/annotationclient.html')
        .pipe(gulp.dest(templateFolder));
});

gulp.task('copy-data', function() {
    gulp.src('./data/**/*')
        .pipe(gulp.dest(staticFolder+'/data'));
});

gulp.task('copy-img', function() {
    gulp.src('./img/**/*')
        .pipe(gulp.dest(staticFolder+'/img'));
});

gulp.task('watch',function(){
    gulp.watch([
        templateFolder+'/**/*.html',
        staticFolder+'/**/*.js',
        staticFolder+'/**/*.css'
    ], function(event) {
        return gulp.src(event.path)
            .pipe(plugins.webserver.reload());
    });
    gulp.watch(['./app/**/*.js','!./app/**/*test.js'],['scripts']);
    gulp.watch('./app/**/*.css',['css']);
    gulp.watch('./app/annotationclient.html',['copy-index']);
    gulp.watch('./data/**/*',['copy-data']);
    gulp.watch('./img/**/*',['copy-img']);

});

gulp.task('connect', function() {
    gulp.src('build').pipe(
        plugins.webserver({
            port: 9000,
            livereload: true
        })
    );
});

gulp.task('default',['scripts','css','copy-index','copy-data','copy-img','vendorJS','vendorCSS','vendorFonts']);
