/**
* js/annotsvizview.js
*
* This is the starting point for your application.
* Take a look at http://browserify.org/ for more info
*/

'use strict';

var PIXI = require('pixi');
var _ = require('lodash');
var DoubleRoll = require('./doubleroll.js');
var AnnotsTimeLine = require('./annotstimeline.js');
var AnnotsRoll = require('./annotsroll.js');

var defaultOptions = {		
    xInit: 0,
    yInit: 0,
    width: 1024,
    height: 768,
};

function AnnotsVizView(options){
	var _this = this;
    var opts = _(options).defaults(defaultOptions).value();
    
    this.container = new PIXI.DisplayObjectContainer();
    this.container.x = opts.xInit;
    this.container.y = opts.yInit;
	this.width = opts.width;
	this.height= opts.height;
	
	var wsPianoroll = opts.wsPianoroll;
	var wsAnnot = opts.wsAnnot;
	var stageView = opts.stageView;
	
	stageView.registerComponent(this);
	
	var timeLine = new AnnotsTimeLine.AnnotsTimeLine({
    	stageView : stageView,
        logger: logger,
        ws: new annotviz.WsWrapper(wsUriAnnotation, logger),
        xInit: 0,
        yInit: 0,
        width: 1024 - 200 - 200,
        height: 768,
        timeBegin: Date.now(),
        timeEnd: Date.now() + 300000,
        intervalWidth: 6,
        intervalHeight: 10,
        maxCellHeight: 100,
        radius: 200,
        circleX:300,
        circleY:400,
        annotCategories: [{
       		ts: 0, 
       		colors: {		
   	       		'ntm': '#CDC83F',
   	       	    'iam': '#CDC83F',
   	       	    'hip': '#CDC83F',
   	       	    'hop': '#CDC83F',
   	       	    'rock': '#DE8B53',
   	       	    'rap': '#DE8B53',
   	       	    'classic': '#DE8B53',
   	       	    'drums': '#C5A3CA',
   	       	    'guitar': '#C5A3CA',
   	       	    'bass': '#79BB92',
   	       	   	'default': '#808080'
			},
        	order: ['ntm', 'iam', 'hip', 'hop', 'rock', 'rap', 'classic', 'drums', 'guitar', 'bass', 'default']
       	}]
    });
	
	
	
	var doubleRollV = new DoubleRoll.DoubleRoll({
        stageView : stageView,
    	logger: logger,
        ws: wsPianoroll,
        orientation: 'vertical',
        sceneHeight: 768,
        pianorolls : [
            {
                height: 200,
                timeWidth: 60,
                lineInterval: 5000,
                noteHeight: undefined
            },
        ]
    });
	
	var annotsRoll = new AnnotsRoll.AnnotsRoll({
    	stageView : stageView,
        logger: logger,
        ws: wsAnnot,
        parentContainer: doubleRollV.stage,
        xInit: 1024 - 200 - 200,
        yInit: 768,
        width: 200 + 200,
        height: 768,
        widthRoll: 200,
        framerate: doubleRollV.framerate,
        pixelsPerSecond: Math.floor(1920 / 60),
        annotColors: [{
        	ts: 0, 
        	colors: {		
   	       		'ntm': '#CDC83F',
   	       	    'iam': '#CDC83F',
   	       	    'hip': '#CDC83F',
   	       	    'hop': '#CDC83F',
   	       	    'rock': '#DE8B53',
   	       	    'rap': '#DE8B53',
   	       	    'classic': '#DE8B53',
   	       	    'drums': '#C5A3CA',
   	       	    'guitar': '#C5A3CA',
   	       	    'bass': '#79BB92',
   	       	   	'default': '#808080'
			}
        }]
    });

	var limiter1 = new PIXI.Graphics()
		.lineStyle(1, 0x000000)
		.moveTo(annotsRoll.container.x, annotsRoll.container.y)
		.lineTo(annotsRoll.container.x, annotsRoll.container.y - annotsRoll.height)
		.endFill();
	this.container.addChild(limiter1);
	
	var limiter2 = new PIXI.Graphics()
		.lineStyle(1, 0x000000)
		.moveTo(annotsRoll.container.x + annotsRoll.widthRoll, annotsRoll.container.y)
		.lineTo(annotsRoll.container.x + annotsRoll.widthRoll, annotsRoll.container.y - annotsRoll.height)
		.endFill();
	this.container.addChild(limiter2);
	
	
//	var doubleRollV = new DoubleRoll.DoubleRoll({});
	
	this.init = function(){
		
	}
	
	this.start = function() {
    };
    
    this.refresh = function() {
    };
    
    this.stop = function(){
    };
    
    return this;
	
}

module.exports = {
	AnnotsVizView: AnnotsVizView
};