/**
* js/wswrapper.js
*
* simple webservice wrapper to register callbacks on onmessage
*
*/

/* global WebSocket: false */

'use strict';

function WsWrapper(wsurl, logger) {

    var url = wsurl;
    var sock = new WebSocket(url);
    var loggerObj = logger;

    var log = function(msg) {
        if(loggerObj) {
            loggerObj.log(msg);
        }
    };

    var handlers = [];

    sock.onopen = function() {
        log('Connected to ' + url);
    };

    sock.onclose = function(e) {
        log('Connection closed (wasClean = ' + e.wasClean + ', code = ' + e.code + ', reason = \'' + e.reason + '\')');
        sock = null;
    };

    sock.onmessage = function(e) {
        log('received ' + e.data);
        var data = JSON.parse(e.data);
        handlers.forEach(function(handler) {
            handler(data);
        });
    };

    this.message = function(handler) {
        if(handler) {
            handlers.push(handler);
        }
    };

}

module.exports = {
    WsWrapper: WsWrapper
};
