/**
* js/annotsvizview.js
*
* This is the starting point for your application.
* Take a look at http://browserify.org/ for more info
*/

'use strict';

var PIXI = require('pixi');
var _ = require('lodash');
var DoubleRoll = require('./doubleroll.js');
var AnnotsTimeLine = require('./annotstimeline.js');
var AnnotsRoll = require('./annotsroll.js');

var defaultOptions = {
    xInit: 0,
    yInit: 0,
    width: 1024,
    height: 768,
    annotCategories: [
    {
        "ts": 1421928213000,
        "colors": {
            "transgressions": "#b90000",
            "rythmique": "#af931e",
            "narration": "#4bdd71",
            "relation": "#1c28ba"
        },
        "order": [
            "transgressions",
            "rythmique",
            "narration",
            "relation"
        ],
        "defaultColor": "#536991"
    }]
};

function AnnotsVizView(options){
	var _this = this;
    var opts = _(options).defaults(defaultOptions).value();

    this.container = new PIXI.DisplayObjectContainer();
    this.container.x = opts.xInit;
    this.container.y = opts.yInit;
	this.width = opts.width;
	this.height= opts.height;
    this.annotCategories = opts.annotCategories;

	var wsPianoroll = opts.wsPianoroll;
	var wsAnnot = opts.wsAnnot;
	var stageView = opts.stageView;

	stageView.registerComponent(this);

	var timeLine = new AnnotsTimeLine.AnnotsTimeLine({
    	stageView : stageView,
        logger: logger,
        ws: new annotviz.WsWrapper(wsUriAnnotation, logger),
        xInit: 0,
        yInit: 0,
        width: 1024 - 200 - 200,
        height: 768-200,
        timeBegin: Date.now(),
        timeEnd: Date.now() + 3000000,
        intervalWidth: 6,
        intervalHeight: 10,
        maxCellHeight: 70,
        radius: 200,
        annotCategories: this.annotCategories
    });

	var doubleRollH = new DoubleRoll.DoubleRoll({
        stageView : stageView,
    	logger: logger,
        ws: wsPianoroll,
        yInit: (this.height - 200),
        sceneHeight: 200,
        pianorolls : [
            {
                height: 200,
                timeWidth: 10,
                lineInterval: 5000,
                noteHeight: 10
            },
        ]
    });

	var doubleRollV = new DoubleRoll.DoubleRoll({
        stageView : stageView,
    	logger: logger,
        ws: wsPianoroll,
        orientation: 'vertical',
        sceneHeight: 768-200,
        pianorolls : [
            {
                height: 200,
                timeWidth: 60,
                lineInterval: 5000,
                noteHeight: 5,
            },
        ]
    });

	var annotsRoll = new AnnotsRoll.AnnotsRoll({
    	stageView : stageView,
        logger: logger,
        ws: wsAnnot,
        parentContainer: doubleRollV.stage,
        xInit: 1024 - 200 - 200,
        yInit: 768-200,
        width: 200 + 200,
        height: 768-200,
        widthRoll: 200,
        framerate: doubleRollV.framerate,
        pixelsPerSecond: Math.floor(1024 / 60),
        annotColors: this.annotCategories
    });

	var limiters = new PIXI.Graphics()
		.lineStyle(1, 0x646464)
		.moveTo(annotsRoll.container.x, annotsRoll.container.y)
		.lineTo(annotsRoll.container.x, annotsRoll.container.y - annotsRoll.height)
		.moveTo(annotsRoll.container.x + annotsRoll.widthRoll, annotsRoll.container.y)
		.lineTo(annotsRoll.container.x + annotsRoll.widthRoll, annotsRoll.container.y - annotsRoll.height)
		.moveTo(0, this.height - 200)
		.lineTo(this.width, this.height - 200)
		.drawRect(0, 0, this.width -1, this.height -1)
		.beginFill(0xECECEC)
		.drawRect(1024 - 200, 0, 200, 768-200)
		.endFill();
	this.container.addChild(limiters);

//	var doubleRollV = new DoubleRoll.DoubleRoll({});

	this.init = function(){

	}

	this.start = function() {
    };

    this.refresh = function() {
    };

    this.stop = function(){
    };

    return this;

}

module.exports = {
	AnnotsVizView: AnnotsVizView
};
