// Config vars
var logger = false;
var sceneWidth = 1920;
//var sceneHeight = 128 * 4; // multiple of 128 because of 128 levels in midi signals ->  better look
var prHeight1 = 435;
var prHeight2 = 645;
var sceneHeight = prHeight1 + prHeight2;
var sceneBgColor = 0xFFFFFF;
var lineColor = 0x444444;
//var manualFramerate = 24;
var pixelsPerSecond1 = Math.floor(sceneWidth / 10); // nb of pixels per second
var manualFramerate = pixelsPerSecond1 / 4;
var pixelsPerSecond2 = Math.floor(sceneWidth / 60); // nb of pixels per second
var lineInterval = 5000; // means line every 5 seconds
var nbLines = -1;
var noteHeight = 110;
var noteColor = 0xB74141;
//var speed = 1; // container -x position at each frame. Speed = 1 ~ 100px for 2 seconds
//var zeroTime = new Date("2014-10-06T12:16:43.000000Z").getTime();
var noteDict = {};
var pianoNotes = [1,0,1,0,1,1,0,1,0,1,0,1];//Do, Do#, Ré, Ré#, Mi, Fa, Fa#, Sol, Sol#, La, La#, Si
// Visual config
var drawPianoNotes = false;
var drawHorizontalLines = false;
var drawVerticalLines = true;


//create an new instance of a pixi stage
var stage = new PIXI.Stage(sceneBgColor);

//create a renderer instance.
var renderer = PIXI.autoDetectRenderer(sceneWidth, sceneHeight);

//add the renderer view element to the DOM
document.getElementById("canvasContainer").appendChild(renderer.view);

//requestAnimFrame( animate );


//Draw 127 lines
var delta = sceneHeight / 128;
if(drawHorizontalLines){
    for(var i=1;i<128;i++){
        var graphics = new PIXI.Graphics();
        graphics.beginFill(0xFFFF00);
        graphics.lineStyle(1, 0xAAAAAA);
        var y = delta * i;
        graphics.moveTo(0, y);
        graphics.lineTo(sceneWidth, y);
        graphics.endFill();
        stage.addChild(graphics);
    }
}

//Draw piano notes on the left
if(drawPianoNotes){
    for(var i=0;i<128;i++){
        var graphics = new PIXI.Graphics();
        var color = pianoNotes[i%12]==1 ? 0xFFFFFF : 0x000000;
        if(i==60){
            color = 0xFFD700;
        }
        graphics.beginFill(color);
        graphics.lineStyle(1, 0xAAAAAA);
        var y = sceneHeight - delta * (i+1);
        graphics.drawRect(0, y, 20, delta);
        graphics.endFill();
        stage.addChild(graphics);
    }
}

var uberContainer = new PIXI.DisplayObjectContainer();
uberContainer.position.x = Math.floor(sceneWidth*9/10);
uberContainer.position.y = 0;
stage.addChild(uberContainer);


var container1 = new PIXI.DisplayObjectContainer();
container1.position.x = 0;
container1.position.y = 0;
uberContainer.addChild(container1);
var container2 = new PIXI.DisplayObjectContainer();
container2.position.x = 0;
container2.position.y = prHeight1;
uberContainer.addChild(container2);

// Line between two containers
var graphics = new PIXI.Graphics();
graphics.beginFill(0xFFFF00);
graphics.lineStyle(1, lineColor);
var y = delta * i;
graphics.moveTo(0, prHeight1);
graphics.lineTo(sceneWidth, prHeight1);
graphics.endFill();
stage.addChild(graphics);

function moveContainer() {
    container1.x -= pixelsPerSecond1/manualFramerate;
    container2.x -= pixelsPerSecond2/manualFramerate;
    renderer.render(stage);
}
function moveContainerMore() {
    container1.x -= 10*(pixelsPerSecond1/manualFramerate);
    container2.x -= 10*(pixelsPerSecond2/manualFramerate);
    renderer.render(stage);
}
function moveContainerRight() {
    container1.x += 10*(pixelsPerSecond1/manualFramerate);
    container2.x += 10*(pixelsPerSecond2/manualFramerate);
    renderer.render(stage);
}

function addBunny(data){
    var timeFromZero = data.content[1];
    var note = data.content[3];
    var velocity = data.content[4];
    if(velocity===0){
        if(note in noteDict){
            // We close the note in container one
            /*var beginTime = new Date(noteDict[note].ts).getTime();
            var beginDelta = beginTime - zeroTime;
            var durationDelta = new Date(data.ts).getTime() - beginTime;
            var beginX = beginDelta * pixelsPerSecond1 / 1000;
            var width = durationDelta * pixelsPerSecond1 / 1000;*/
            var beginX = noteDict[note].ts * pixelsPerSecond1 / 1000;
            var width = (timeFromZero - noteDict[note].ts) * pixelsPerSecond1 / 1000;
            // We draw the rectangle
            var graphics = new PIXI.Graphics();
            graphics.beginFill(noteColor, (noteDict[note].velocity / 128));
            var y = (128-note) * prHeight1 / 128; // (128-note) because y = 0 is for note = 128 and y = 128 for note = 0
            graphics.drawRect(beginX, Math.floor(y - (noteHeight/2) + ((prHeight1 / 128)/2)), width, noteHeight);
            graphics.endFill();
            container1.addChild(graphics);
            // container 2
            beginX = noteDict[note].ts * pixelsPerSecond2 / 1000;
            width = (timeFromZero - noteDict[note].ts) * pixelsPerSecond2 / 1000;
            // We draw the rectangle
            graphics = new PIXI.Graphics();
            graphics.beginFill(noteColor, (noteDict[note].velocity / 128));
            y = (128-note) * prHeight2 / 128; // (128-note) because y = 0 is for note = 128 and y = 128 for note = 0
            graphics.drawRect(beginX, Math.floor(y - (noteHeight/2) + ((prHeight2 / 128)/2)), width, noteHeight);
            graphics.endFill();
            container2.addChild(graphics);
            // delete entry
            delete noteDict[note];
        }
    }
    else{
        noteDict[note] = {ts: timeFromZero, velocity:velocity};
    }
}

// Socket management
var sock = null;
var ellog = null;
function log(m) {
    if(logger){
        ellog.innerHTML += m + '\n';
        ellog.scrollTop = ellog.scrollHeight;
    }
}
window.onload = function() {

    if(logger){
        ellog = document.getElementById('log');
    }
    else{
        document.body.removeChild(document.getElementById('log'));
    }

    var wsuri;
    if (window.location.protocol === "file:") {
       wsuri = "ws://127.0.0.1:8090/broadcast";
    } else {
       wsuri = "ws://" + window.location.hostname + ":8090/broadcast";
    }
    if ("WebSocket" in window) {
       sock = new WebSocket(wsuri);
    } else if ("MozWebSocket" in window) {
       sock = new MozWebSocket(wsuri);
    } else {
       log("Browser does not support WebSocket!");
       window.location = "http://autobahn.ws/unsupportedbrowser";
    }

    if (sock) {
       sock.onopen = function() {
           if(logger){
               log("Connected to " + wsuri);
           }
       }

       sock.onclose = function(e) {
           if(logger){
               log("Connection closed (wasClean = " + e.wasClean + ", code = " + e.code + ", reason = '" + e.reason + "')");
           }
          sock = null;
       }

       sock.onmessage = function(e) {
           if(logger){
               log("Got message: " + e.data);
           }
          addBunny(JSON.parse(e.data));
       }
    }
};


function addLine(){
    nbLines++;
    var graphics = new PIXI.Graphics();
    var x = nbLines * (lineInterval/1000) * pixelsPerSecond1;
    //console.log("nbLines = ",nbLines, "x = ", x);
    graphics.beginFill(0xFFFF00);
    graphics.lineStyle(1, lineColor);
    graphics.moveTo(x, prHeight1 - 20);
    graphics.lineTo(x, prHeight1);
    graphics.endFill();
    container1.addChild(graphics);
    // Add text
    var totalSec = nbLines * lineInterval / 1000;
    var hours = parseInt( totalSec / 3600 ) % 24;
    var minutes = parseInt( totalSec / 60 ) % 60;
    var seconds = totalSec % 60;
    var timeStr = (hours < 10 ? "0" + hours : hours) + ":" + (minutes < 10 ? "0" + minutes : minutes) + ":" + (seconds  < 10 ? "0" + seconds : seconds);
    var fontObj = { font: "10pt Arial", fill: "#444444" };
    var t = new PIXI.Text(timeStr, fontObj);
    t.x = x + 2;
    t.y = prHeight1 - 15;
    container1.addChild(t);
    // Second container
    graphics = new PIXI.Graphics();
    x = nbLines * (lineInterval/1000) * pixelsPerSecond2;
    graphics.beginFill(0xFFFF00);
    graphics.lineStyle(1, lineColor);
    graphics.moveTo(x, 0);
    graphics.lineTo(x, 20);
    graphics.endFill();
    container2.addChild(graphics);
    var t = new PIXI.Text(timeStr, fontObj);
    t.x = x + 2;
    t.y = 2;
    container2.addChild(t);
    
}
addLine();
var moveInterval = window.setInterval(moveContainer, 1000/manualFramerate);
var verticalLinesInterval = false;
if(drawVerticalLines){
    verticalLinesInterval = window.setInterval(addLine, lineInterval);
}
var nbSec = 0;
var mySpan = document.getElementById("myspan");
function updateTime(){
    nbSec++;
    var hours = parseInt( nbSec / 3600 ) % 24;
    var minutes = parseInt( nbSec / 60 ) % 60;
    var seconds = nbSec % 60;
    var timeStr = (hours < 10 ? "0" + hours : hours) + ":" + (minutes < 10 ? "0" + minutes : minutes) + ":" + (seconds  < 10 ? "0" + seconds : seconds);
    mySpan.innerHTML = timeStr;
}
var secondInterval = window.setInterval(updateTime, 1000);
