/**
* js/wswrapper.js
*
* simple logger service
*
*/

/* global document: false */

'use strict';

function HtmlLogger(doLog, container) {

    var logContainer = container;
    if(typeof(container) === 'string') {
        logContainer = document.getElementById(container);
    }
    if(!doLog) {
        document.body.removeChild(logContainer);
        logContainer = undefined;
    }


    this.log = function(msg) {
        if(doLog && logContainer) {
            logContainer.innerHTML += msg + '\n';
            logContainer.scrollTop = logContainer.scrollHeight;
        }
    };
}

function ConsoleLogger(doLog) {

    this.log = function(msg) {
        if(doLog) {
            console.log(msg);
        }
    };

}

module.exports = {
    HtmlLogger: HtmlLogger,
    ConsoleLogger: ConsoleLogger
};
