(function(){
    'use strict';

    angular.module('mons', [ 'ngResource', 'ngRoute', 'autocomplete' ])
        .config(function($routeProvider) {
            $routeProvider.
                when('/', {
                    controller: 'homeCtrl'
               }).
               otherwise({
                   redirectTo: '/'
               });
        })
        .config(function($logProvider){
            $logProvider.debugEnabled(true);
        })
        .service('dataApi', function($resource, context) {
            console.log('dataApi',$resource, context);
            this.dataResource = $resource(context.urls.dataUrl);
        })
        .service('dataModel', function(dataApi) {
            //console.log('dataModel',this,dataApi);
            this.data = dataApi.dataResource.get();
        })
        .controller('homeCtrl', function($scope, $location, dataModel){
            console.log('homeCtrl 1', $scope, $location);
            $scope.data = dataModel.data;
            
            dataModel.data.$promise.then(function(data) {
                if(typeof data.categories!=='undefined' && data.categories.length>0){
                    console.log('    JE RENTRE');
                    var cats = [];
                    var nbCat = data.categories.length;
                    for(var i=0;i<nbCat;i++){
                        cats.push(data.categories[i].label);
                        if(typeof data.categories[i].subcategories!=='undefined' && data.categories[i].subcategories.length>0){
                            var nbSubCat = data.categories[i].subcategories.length;
                            for(var j=0;j<nbSubCat;j++){
                                cats.push(data.categories[i].subcategories[j].label);
                            }
                        }
                    }
                    $scope.allCatLabels = cats;
                }
            });
            
            $scope.selectedlevel = false;
            
            //console.log('homeCtrl 1-3', dataModel.data.categories);
            //$scope.selectedlevel = $scope.data.categories;
            //console.log('homeCtrl 2', $scope.selectedLevel, $scope.data);
            
            $scope.sendAnnotation = function(eventCode){
                console.log('ntm', $scope.username);
                if($scope.username==='' || typeof $scope.username==='undefined'){
                    alert('Vous devez indiquer un nom d\'utilisateur.');
                    return;
                }
                if(eventCode==='' || typeof eventCode==='undefined'){
                    alert('Vous devez indiquer un nom de catégorie.');
                    return;
                }
                // Send query
                alert('annotation envoyée ! eventCode = ' + eventCode);
            };
            
            $scope.selectLevel = function(i, eventCode){
                if(i===false){
                    $scope.returnVisStyle = {visibility:'hidden'};
                    $scope.selectedlevel = false;
                    return;
                }
                if(typeof $scope.data.categories[i].subcategories!=='undefined' && $scope.data.categories[i].subcategories.length>0){
                    $scope.selectedlevel = $scope.data.categories[i].subcategories;
                    $scope.returnVisStyle = {visibility:'show'};
                }
                else{
                    // Send query
                    $scope.sendAnnotation(eventCode);
                }
            };
            
            $scope.onSelect = function(suggestion){
                console.log('ON SELECT',suggestion);
            };
            
            $scope.onAutocompleteType = function(){
                console.log('onAutocompleteType');
            };
        });

})();
