# yo
import argparse
import json
import sys
import urllib


def get_options():

    parser = argparse.ArgumentParser(description="Create url for iframe in Mons projects")
    
    parser.add_argument("-p", "--project", dest="project_id",
                      help="project uuid", metavar="PROJECT_UUID", required=True)

    return (parser.parse_args(), parser)


if __name__ == "__main__" :
    
    (options, parser) = get_options()
    
    if len(sys.argv) == 1 or options.project_id is None:
        parser.print_help()
        sys.exit(1)
    
    path = "../client/data/categories.json"
    json_file=open(path)
    data = json.load(json_file)
    json_file.close()
    
    output = []
    
    for c in data["categories"]:
        if "subcategories" in c and len(c["subcategories"])>0:
            for sc in c["subcategories"]:
                output.append({"name": sc["code"],"keywords": [ sc["label"] ], "color" : sc["color"] })
        else:
            output.append({"name": c["code"],"keywords": [ c["label"] ], "color" : c["color"] })
    
    base_url = "http://ldt.iri.centrepompidou.fr/ldtplatform/ldt/embediframe/?project_id=" + options.project_id + "&polemic=all&polemics_list="
    output_str = json.dumps(output, separators=(',',':'))
    
    print "SIMPLE JSON DUMPS :"
    print base_url + output_str
    print "\nURLLIB QUOTE_PLUS JSON DUMPS :"
    print base_url + urllib.quote_plus(output_str)



