/**
* js/utils.js
*
* basic tools
*
*/

'use strict';

var PIXI = require('pixi');
var _ = require('lodash');
var moment = require('moment');

function formatTime (ts) {
	return moment(ts).format("HH:mm:ss");
}

function colorToHex(c) {
	var m = /rgba?\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)/.exec(c);
	return m ? '#' + (1 << 24 | m[1] << 16 | m[2] << 8 | m[3]).toString(16).substr(1) : c;
}

function getAnnotCategories(urlCategories, annotCategories) {

    var jsonLoader = new PIXI.JsonLoader(urlCategories, true);

    jsonLoader.on('loaded', function(res) {
        var data = res.target.json;

        while(annotCategories.length > 0) {
        	annotCategories.pop();
        }

        data.sessions.forEach(function(session) {
            var annotCat = {
                ts: session.start_ts === null ? new Date(0) : Date.parse(session.start_ts),
                colors: {}
            }
            var categoriesJson = session.categories_json;
            annotCat.order = categoriesJson.order;
            if (typeof(annotCat.order['default']) === 'undefined'){
            	annotCat.order.push('default');
            }
			var catList = _.clone(categoriesJson.categories);
			while(catList.length > 0) {
				var cat = catList.pop();
				if(cat.code) {
					annotCat.colors[cat.code] = colorToHex(cat.color);
				}
				if(cat.subcategories) {
					catList = catList.concat(cat.subcategories);
				}
			}
            categoriesJson.categories.forEach(function(cat) {
				if(cat.code) {
                	annotCat.colors[cat.code] = colorToHex(cat.color);
				}
            });
            annotCat.defaultColor = categoriesJson.defaultColor || "#536991";
            annotCategories.push(annotCat);
        });
    });

    jsonLoader.load();

}

module.exports = {
	formatTime: formatTime,
	getAnnotCategories: getAnnotCategories,
	colorToHex: colorToHex
};
