#!/usr/bin/env python
"""
Example of a UDP txosc sender with Twisted.

This example is in the public domain.
"""

import argparse
import csv
import sys
import time

from twisted.internet import reactor
from txosc import osc
from txosc import dispatch
from txosc import async


class UDPSenderApplication(object):
    """
    Example that sends UDP messages.
    """
    def __init__(self, port, host, address, rows):
        self.port = port
        self.host = host
        self.client = async.DatagramClientProtocol()
        self._client_port = reactor.listenUDP(0, self.client)
        self.rows = rows
        self.address = address
        reactor.callLater(0, self.send_messages)

    def _send(self, element):
        # This method is defined only to simplify the example
        self.client.send(element, (self.host, self.port))
        print("Sent %s to %s:%d" % (element, self.host, self.port))

    def send_messages(self):
        tc = 0
        for row in self.rows:
            row_conv = [ osc.TimeTagArgument(float(row[0]))] + [osc.IntArgument(int(a)) for a in row[1:]]
            #time.sleep((row_conv[1].value-tc)/10**3)
            time.sleep(0.1)
            #tc = row_conv[1].value
            self._send(osc.Message(self.address,*row_conv))
        print("Goodbye.")
        reactor.callLater(0.1, reactor.stop)

if __name__ == "__main__":

    parser = argparse.ArgumentParser(description='Simulate an (osc) pianoroll client.')
    parser.add_argument('datafile', metavar='DATAFILE', help='The file containing the pianoroll data (CSV).')
    parser.add_argument('-e', '--event', dest='event', metavar='EVENT', required=True, help='the event code.')

    args = parser.parse_args()

    with open(args.datafile, 'rU') as datafile:
        reader = csv.reader(datafile, delimiter=' ')
        app = UDPSenderApplication(9090, "127.0.0.1", "/pianoroll/%s/" % args.event, list(reader))

    reactor.run()
