/**
* js/annotsvizview.js
*
* This is the starting point for your application.
* Take a look at http://browserify.org/ for more info
*/
/*jshint unused:false */

'use strict';

var PIXI = require('pixi');
var _ = require('lodash');
var DoubleRoll = require('./doubleroll');
var AnnotsTimeLine = require('./annotstimeline');
var AnnotsRoll = require('./annotsroll');
var Utils = require('./utils');

var defaultOptions = {
    xInit: 0,
    yInit: 0,
    width: 1024,
    height: 768
};

function AnnotsVizView(options){
    var _this = this;
    var opts = _(options).defaults(defaultOptions).value();

    this.container = new PIXI.DisplayObjectContainer();
    this.container.x = opts.xInit;
    this.container.y = opts.yInit;
    this.width = opts.width;
    this.height= opts.height;
    this.timeBegin = opts.timeBegin;
    this.timeEnd = opts.timeEnd;
    this.annotCategories = [];

    Utils.getAnnotCategories(opts.urlCategories, this.annotCategories);

    var wsPianoroll = opts.wsPianoroll;
    var wsAnnot = opts.wsAnnot;
    var stageView = opts.stageView;
    var eventCode = opts.eventCode;
    var channel = opts.channel;
    var logger = opts.logger;

    stageView.registerComponent(this);

    var timeLineDay2 = new AnnotsTimeLine.AnnotsTimeLine({
        stageView : stageView,
        logger: logger,
        ws: wsAnnot,
        xInit: 0,
        yInit: 0,
        width: 1024 - 200 - 200,
        height: 768-200,
        timeBegin: this.timeBegin,
        timeEnd: this.timeEnd,
        intervalWidth: 6,
        intervalHeight: 10,
        maxCellHeight: 70,
        radius: 200,
        eventCode: eventCode,
        channel: channel,
        annotCategories: this.annotCategories
    });

    //Archive day 1
    /*jshint -W098 */
    var timeLineDay1 = new AnnotsTimeLine.AnnotsTimeLine({
        stageView : stageView,
        archive: true,
        xInit: 0,
        yInit: 0,
        width: 1024 - 200 - 200,
        height: 768-200,
        timeBegin: Date.parse('2015-01-22T09:30:00+01:00'),
        timeEnd: Date.parse('2015-01-22T18:30:00+01:00'),
        circleX: timeLineDay2.circleX,
        circleY: timeLineDay2.circleY,
        intervalWidth: (timeLineDay2.radius*2/3)* timeLineDay2.intervalWidth / timeLineDay2.radius,
        intervalHeight: (timeLineDay2.intervalHeight * (timeLineDay2.radius - timeLineDay2.radius*2/3))/ timeLineDay2.maxCellHeight,
        maxCellHeight: (timeLineDay2.radius - timeLineDay2.radius*2/3)/4,
        radius: timeLineDay2.radius*2/3,
        annotCategories: this.annotCategories,
        eventCode: eventCode,
        channel: channel,
        showClockGraphics:false
    });

    var currentTimeText = new PIXI.Text('-- : -- : --', { font: '18pt Gothic Standard', fill: '#646464' });
    currentTimeText.x = timeLineDay2.circleX - currentTimeText.width/2;
    currentTimeText.y = timeLineDay2.circleY - currentTimeText.height/2;
    this.container.addChild(currentTimeText);

    var timeLineDay3 = new PIXI.Graphics();
    timeLineDay3.lineStyle(1, 0x646464)
        .drawCircle(timeLineDay2.circleX, timeLineDay2.circleY, timeLineDay2.radius/3)
        .endFill();
    this.container.addChild(timeLineDay3);

    /*jshint -W098 */
    var doubleRollH = new DoubleRoll.DoubleRoll({
        stageView : stageView,
        logger: logger,
        ws: wsPianoroll,
        yInit: (this.height - 200),
        sceneHeight: 200,
        pianorolls : [
            {
                height: 200,
                timeWidth: 10,
                lineInterval: 5000,
                noteHeight: 10
            },
        ]
    });

    var doubleRollV = new DoubleRoll.DoubleRoll({
        stageView : stageView,
        logger: logger,
        ws: wsPianoroll,
        orientation: 'vertical',
        sceneHeight: 768-200,
        pianorolls : [
            {
                height: 200,
                timeWidth: 60,
                lineInterval: 5000,
                noteHeight: 5,
            },
        ]
    });

    var annotsRoll = new AnnotsRoll.AnnotsRoll({
        stageView : stageView,
        logger: logger,
        ws: wsAnnot,
        parentContainer: doubleRollV.stage,
        xInit: 1024 - 200 - 200,
        yInit: 768-200,
        width: 200 + 200,
        height: 768-200,
        widthRoll: 200,
        framerate: doubleRollV.framerate,
        pixelsPerSecond: Math.floor(1024 / 60),
        annotColors: this.annotCategories
    });

    var limiters = new PIXI.Graphics()
        .lineStyle(1, 0x646464)
        .moveTo(annotsRoll.container.x, annotsRoll.container.y)
        .lineTo(annotsRoll.container.x, annotsRoll.container.y - annotsRoll.height)
        .moveTo(annotsRoll.container.x + annotsRoll.widthRoll, annotsRoll.container.y)
        .lineTo(annotsRoll.container.x + annotsRoll.widthRoll, annotsRoll.container.y - annotsRoll.height)
        .moveTo(0, this.height - 200)
        .lineTo(this.width, this.height - 200)
        .drawRect(0, 0, this.width -1, this.height -1)
        .beginFill(0xECECEC)
        .drawRect(1024 - 200, 0, 200, 768-200)
        .endFill();
    this.container.addChild(limiters);

    this.init = function(){
    };

    this.updateTime = function(){
        currentTimeText.setText(Utils.formatTime(Date.now()));
    };

    var refreshTimeInterval;

    this.start = function() {
        refreshTimeInterval = setInterval(function() {_this.updateTime();}, 1000);
    };

    this.refresh = function() {
    };

    this.stop = function(){
    };

    return this;

}

module.exports = {
    AnnotsVizView: AnnotsVizView
};
