'use strict';

var config = require('../config');
var path = require('path');
var gulp = require('gulp');
var cache = require('gulp-cache');
var changed = require('gulp-changed');
var imagemin = require('gulp-imagemin');
var size = require('gulp-size');

// Images
gulp.task('images', function() {
	var dest = config.dist + '/img';

	return gulp.src('app/img/**/*')
		.pipe(changed(dest)) // Ignore unchanged files
		.pipe(imagemin()) // Optimize
		.pipe(gulp.dest(dest));
});


// Images Dist
gulp.task('images:dist', ['images'], function () {
  var dest = config.dist + '/img';
  return gulp.src(['app/img/**/*'], {base: path.resolve('app')+"/img"})
    // Commenting out the cache section for now.
    // .pipe(gulp.dest('dist'))
    // .pipe(rev())
    // .pipe(cache(imagemin({
    //   optimizationLevel: 3,
    //   progressive: true,
    //   interlaced: false
    // })))
    .pipe(imagemin()) // Optimize
    .pipe(size())
	.pipe(gulp.dest(dest));
});
