from rest_framework.authentication import BaseAuthentication
from django.contrib.auth import get_user_model, login
from django.contrib.auth.models import Permission
from django.conf import settings
import requests
import re
import json

class MtdcOAuth2ClientCredentialsAuthentication(BaseAuthentication):
    
    def authenticate(self, request):
        # get token, get username
        if 'act_as' not in request.GET or 'HTTP_RENKAN_ACT_AS' not in request.META:
            return
        else:
            username = request.GET.get('act_as', request.META.get("HTTP_RENKAN_ACT_AS", ""))
        try: 
            user = get_user_model().objects.get(username=username)
        except get_user_model().DoesNotExist:
            return
        if 'HTTP_AUTHORIZATION' not in request.META:
            return
        else:
            token = re.search("(?<=\s).*", request.META["HTTP_AUTHORIZATION"]).group(0)
        
        # send token to Oauth server
        token_validate_response = requests.get(
            settings.MTDC_VALIDATE_TOKEN_URL+token
        )
        if token_validate_response.status_code != 200:
            return
        return (user, None)
    
