# OAuth 2 Server & GED mock client for test and development

## INSTALLATION

use a different virtualenv than the one for the django metaeducation app

$ mkvirtualenv mtdc_oauth_env
$ pip install -r requirements.txt

## CONFIGURATION

Edit client_settings.py.tmpl and oauth_settings.py.tmpl to match your renkan django app config.

## RUNNING

To run the oauth server:

	$ workon mtdc_oauth_env
	$ python oauth.py

To run the GED mock client:

	$ workon mtdc_oauth_env
	$ python client.py

Oauth server runs on 127.0.0.1:5000
Mock ged client runs on 127.0.0.1:8000

NOTE: OAuth server will expect you to run Renkan django project on 127.0.0.1:8001

## GETTING MOCK GED CLIENT ID AND SECRET

You need to run oauth.py, then go to 127.0.0.1:500/get-client-credentials .
The Oauth server will print a JSON with client_id and client_secret that will allow you to complete the client_settings.py

## USAGE

First of all you must log into the oauth server

	127.0.0.1:5000
	
Once you are logged, you can visit the mock GED client

	127.0.0.1:8000
	
You will start an authorization flow that will validate that you are logged into the OAuth server 
(note: while Itop's server will auto-validate clients, we keep the validation steps for testing and dev as it makes debugging easier)

From there you end up on the client's main page, with two links

* One of them is a link to a new Renkan that will open in your browser when everything is properly configured (see server/src/metaeducation/README.md to configure the django app), using Authorization Code flow
* The other is a link to create a new Renkan from the API endpoint, using client credentials OAuth flow