import logging, json
import requests
from django.conf import settings
from django.http import HttpResponse, HttpResponseServerError
from django.views.generic import View

logger = logging.getLogger(__name__)

class UITrackingView(View):

    def send_tracking_data(self, json_data):
        tracking_data = json.loads(json_data)
        logger.debug("SENDING %r", tracking_data)
        resp = requests.post(
            settings.LRS_TRACKING_SERVICE_URL + "statements",
            json=tracking_data,
            auth=requests.auth.HTTPBasicAuth(
                settings.LRS_MTDC_RENKAN_USERNAME,
                settings.LRS_MTDC_RENKAN_PASSWORD
            ),
            headers = {"X-Experience-API-Version": "1.0.1"}
        )
        logger.debug("%r: %r", resp.status_code, resp.text)
        return resp

    def post(self, request):
        logger.debug("POSTING DATA %r", str(request.body, 'utf-8'))

        try:
            resp = self.send_tracking_data(str(request.body, 'utf-8'))
            resp.raise_for_status()
        except requests.exceptions.ConnectionError as e:
            logger.debug("ERROR Connecting %r", e)
            return HttpResponseServerError(str(e))
        except requests.exceptions.HTTPError as e:
            logger.debug("ERROR POSTING DATA %r", e)
            return HttpResponse(resp.text, status=resp.status_code, content_type='text/plain')
        else:
            httpresp = HttpResponse(resp.text, status=resp.status_code, content_type=resp.headers.get('content-type'))
            for h in {'X-Experience-API-Consistent-Through', 'X-Experience-API-Version', 'Date'}.intersection(resp.headers.keys()):
                httpresp[h] = resp.headers[h]
            return httpresp
