import logging, json
import requests
from django.conf import settings
from metaeducation.celery import app as celery_app

logger = logging.getLogger(__name__)

@celery_app.task()
def send_tracking_data(json_data):

    tracking_data = (json_data if isinstance(json_data, str) else json.dumps(json_data)).encode('utf-8')

    logger.debug("SENDING %r", tracking_data)

    try:
        resp = requests.post(
            settings.LRS_TRACKING_SERVICE_URL + "statements",
            data=tracking_data,
            auth=requests.auth.HTTPBasicAuth(
                settings.LRS_MTDC_RENKAN_USERNAME,
                settings.LRS_MTDC_RENKAN_PASSWORD
            ),
            headers = {"X-Experience-API-Version": "1.0.1", "Content-Type": "application/json"}
        )
        logger.debug("tracking info sent %r: %r", resp.status_code, resp.text)
        resp.raise_for_status()
    except requests.exceptions.ConnectionError as e:
        logger.exception("Tracking send error Connecting %r", e)
        # do nothing this should be a fire and forget interface
    except requests.exceptions.HTTPError as e:
        logger.debug("Tracking send error posting data %r", e)
        # do nothing this should be a fire and forget interface
