import logging
import uuid

from django.db.models.signals import pre_delete, post_save
from django.utils.functional import curry

from renkanmanager.models import Renkan, Revision

from . import register_handlers, unregister_handlers, register_pre_save_handlers

logger = logging.getLogger(__name__)


class TrackingMiddleware(object):
    def process_request(self, request):
        if not request.method in ('GET', 'HEAD', 'OPTIONS', 'TRACE'):
            if hasattr(request, 'user') and request.user.is_authenticated():
                user = request.user.external_id
            else:
                user = None

            request.renkan_request_id = str(uuid.uuid4())
            register_handlers(user, request.renkan_request_id)


    def process_response(self, request, response):
        if hasattr(request, 'renkan_request_id'):
            unregister_handlers(request.renkan_request_id)
        return response

    def process_view(self, request, view_func, view_args, view_kwargs):
        if view_func.__name__ == 'RenkanDetail' and view_func.__module__ == 'renkanmanager.api.views' and request.method == 'PUT' and 'renkan_guid' in view_kwargs:
            if hasattr(request, 'user') and request.user.is_authenticated():
                user = request.user.external_id
            else:
                user = None
            # this test should never fail
            if not hasattr(request, 'renkan_request_id'):
                request.renkan_request_id = str(uuid.uuid4())
            register_pre_save_handlers(user, request.renkan_request_id)
        return None
