
from allauth.socialaccount import providers
from allauth.socialaccount.providers.base import ProviderAccount
from allauth.socialaccount.providers.oauth2.provider import OAuth2Provider
from django.conf import settings

class MtdcProvider(OAuth2Provider):
    id = 'mtdc'
    name = 'MTDC'
    package = 'metaeducation.mtdc_oauth_provider'
    
    def extract_uid(self, data):
        print("retrieved data: "+str(data))
        return data.get(settings.MTDC_USERID_FIELD_NAME, '')

    def extract_common_fields(self, data):
        return {"username": data.get(settings.MTDC_USERNAME_FIELD_NAME, "")}

    def extract_extra_data(self, data):
        return {"username": data.get(settings.MTDC_USERNAME_FIELD_NAME, "")}
    
providers.registry.register(MtdcProvider)