from django.db.models.signals import post_save
from django.dispatch import receiver
from django.contrib.auth import get_user_model
from django.conf import settings
import requests, json

@receiver(post_save)
def reference_created_renkan(sender, instance, created, **kwargs):
    from renkanmanager.models import Renkan
    if created and sender == Renkan and instance.source_renkan_guid:
        token_response = requests.post(
            settings.MTDC_CLIENT_CREDENTIALS_TOKEN_URL+"?grant_type=client_credentials",
            data = {},
            headers = {
                "Authorization": "Basic %s" % settings.MTDC_AUTH_CODE
            }          
        )
        if token_response.status_code == 200:
            token = json.loads(token_response.text)['access_token']
            post_data = json.dumps({
                "userId": instance.creator.id,
                "title": instance.title
            })
            reference_response = requests.post(
                settings.MTDC_REFERENCE_RESOURCE_BASE_URL+str(instance.renkan_guid),
                data = post_data,
                headers = {
                    "Authorization": "Bearer %s" % token
                }                             
            )
"""     
@receiver(post_save)
def reference_modified_title(sender, instance, created, **kwargs):
    from renkanmanager.models import Renkan, Revision
    if created and sender == Revision:
        try:
            referenced_renkan = Renkan.objects.get(renkan_guid = instance.revision_guid)
        except Renkan.DoesNotExist:
            return
        if referenced_renkan.revision_count > 1:
            # This means the revision isn't the first of the Renkan and therefore we shouldn't do anything
            token_response = requests.post(
                settings.MTDC_CLIENT_CREDENTIALS_TOKEN_URL+"?grant_type=client_credentials",
                data = {},
                headers = {
                    "Authorization": "Basic %s" % settings.MTDC_AUTH_CODE
                }                             
            )
            if token_response.status_code == 200:
                token = json.loads(token_response.text)['access_token']
                put_data = json.dumps({
                    "userId": referenced_renkan.creator.id,
                    "title": referenced_renkan.title
                })
                reference_response = requests.post(
                    settings.MTDC_REFERENCE_RESOURCE_BASE_URL+str(instance.renkan_guid),
                    data = put_data,
                    headers = {
                        "Authorization": "Bearer %s" % token
                    }                             
                )
"""