from flask import Flask, url_for, session, request, jsonify
from flask_oauthlib.client import OAuth
from settings.client_settings import ClientSettings



app = Flask(__name__)
app.debug = True
app.secret_key = 'secret'
app.config.from_object(ClientSettings)
oauth = OAuth(app)

remote = oauth.remote_app(
    'remote',
    consumer_key=app.config.get("CLIENT_ID", ""),
    consumer_secret=app.config.get("CLIENT_SECRET", ""),
    request_token_params=app.config.get("REQUEST_TOKEN_PARAMS", ""),
    base_url=app.config.get("BASE_URL", ""),
    request_token_url=app.config.get("REQUEST_TOKEN_URL", ""),
    access_token_url=app.config.get("ACCESS_TOKEN_URL", ""),
    authorize_url=app.config.get("AUTHORIZE_URL", "")
)


@app.route('/')
def index():
    if 'remote_oauth' in session:
        resp = remote.get('me')
        return jsonify(resp.data)
    next_url = request.args.get('next') or request.referrer or None
    return remote.authorize(
        callback=url_for('authorized', next=next_url, _external=True)
    )


@app.route('/authorized')
def authorized():
    resp = remote.authorized_response()
    if resp is None:
        return 'Access denied: reason=%s error=%s' % (
            request.args['error_reason'],
            request.args['error_description']
        )
    print resp
    session['remote_oauth'] = (resp['access_token'], '')
    return jsonify(oauth_token=resp['access_token'])


@remote.tokengetter
def get_oauth_token():
    return session.get('remote_oauth')


if __name__ == '__main__':
    import os
    os.environ['DEBUG'] = 'true'
    os.environ['OAUTHLIB_INSECURE_TRANSPORT'] = 'true'
    app.run(host='localhost', port=8000)
