"""metaeducation URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/1.8/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  url(r'^$', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  url(r'^$', Home.as_view(), name='home')
Including another URLconf
    1. Add an import:  from blog import urls as blog_urls
    2. Add a URL to urlpatterns:  url(r'^blog/', include(blog_urls))
"""
from django.conf.urls import include, url
from django.contrib import admin
from django.contrib.admin.views.decorators import staff_member_required
from django.contrib.staticfiles.urls import staticfiles_urlpatterns
from django.core.urlresolvers import reverse_lazy
from django.views.generic import RedirectView

from .views import ListRenkansView, NewRenkanView, EditRenkanView, ViewRenkanView, DeleteRenkanView, UITrackingView, UITrackingViewClose


urlpatterns = [
    url(r'^$', RedirectView.as_view(url=reverse_lazy("front_list_renkans"))),
    url(r'^admin/', include(admin.site.urls)),
    url(r'^api/', include('renkanmanager.urls')),
    url(r'^accounts/', include('allauth.urls')),
    url(r'^front/list/$', staff_member_required(ListRenkansView.as_view()), name='front_list_renkans'),
    url(r'^front/new/$', NewRenkanView.as_view(), name='front_new_renkan'),
    url(r'^front/edit/(?P<renkan_guid>[\w-]+)/$', EditRenkanView.as_view(), name='front_edit_renkan'),
    url(r'^front/view/(?P<renkan_guid>[\w-]+)/$', ViewRenkanView.as_view(), name='front_view_renkan'),
    url(r'^tracking/$', UITrackingView.as_view(), name='tracking_view'),
    url(r'^tracking/close/$', UITrackingViewClose.as_view(), name='tracking_view_close'),
    url(r'^front/delete/(?P<renkan_guid>[\w-]+)/$', staff_member_required(DeleteRenkanView.as_view()), name='front_delete_renkan')
]

urlpatterns += staticfiles_urlpatterns()
