/* global require module */

var babel = require('broccoli-babel-transpiler');
var mergeTrees = require('broccoli-merge-trees');
var funnel = require('broccoli-funnel');

var scriptTree = babel('assets/js', {browserPolyfill: true});
var jsTree = funnel(scriptTree, {destDir: 'js'});
var cssTree = funnel('assets/css', {destDir: 'css'});
var libTree = funnel('assets/lib', {destDir: 'lib'});


// Merge the compiled styles and scripts into one output directory.
module.exports = mergeTrees([jsTree, cssTree, libTree]);
