import datetime
import json
import logging
import pytz

from .tasks import send_tracking_data

logger = logging.getLogger(__name__)


def get_base_message(verb, renkan_id, current_user, registration = None):
    #create
    #open-read
    #open-edit
    #close
    #delete
    #update
    timestamp = datetime.datetime.utcnow().replace(tzinfo=pytz.utc)

    verbNode = {
        "create" : {
            "id": 'http://activitystrea.ms/schema/1.0/create',
            "display": { 'fr-FR': 'a créé' }
        },
        "update": {
            "id": 'http://activitystrea.ms/schema/1.0/update',
            "display": { 'fr-FR': 'a modifié' }
        },
        "delete": {
            "id": 'http://activitystrea.ms/schema/1.0/delete',
            "display": { 'fr-FR': 'a supprimé' }
        },
        "close": {
            "id": 'http://activitystrea.ms/schema/1.0/close',
            "display": { 'fr-FR': 'a fermé'}
        },
        "open_read": {
            "id": 'http://id.tincanapi.com/verb/viewed',
            "display": { 'fr-FR': 'a vu'}
        },
        "open_edit": {
            "id" : 'http://activitystrea.ms/schema/1.0/access',
            "display": { 'fr-FR': "a édité" }
        }
    }[verb];
    msg = {
        'actor': {
            'objectType': 'Agent',
            'name': current_user,
            'account': {
                'homePage': 'https://www.metaeducation.fr/Utilisateurs/',
                'name': current_user
            }
        },
        'verb': verbNode,
        'object': {
            'objectType': 'Activity',
            'id': get_renkan_urn(renkan_id)
        },
        'context': {
            'extensions': {
                'http://liris.renkantracking.org/application': 'Outil carte mentale'
            }
        },
        'timestamp': timestamp.isoformat()
    };
    if registration:
        msg['context']['registration'] = registration

    return msg

def get_renkan_urn(renkan_id):
    return 'urn:mtdc:renkan:renkan:%s' % renkan_id;



def send_close_renkan(renkan, current_user, registration):
    msg = get_base_message('close', renkan.renkan_guid, current_user, registration)

    msg['object'] = {
        **(msg['object']),
        **{
            "definition": {
                "name": {
                    'fr-FR': renkan.title
                },
                "type": "http://www.w3.org/ns/activitystreams#Renkan",
                "extensions": {
                    'http://www.w3.org/ns/activitystreams#Data': json.loads(renkan.content),
                }
            }
        }
    }

    send_tracking_data(msg)
