/* Saves the Full JSON at each modification */

Rkns.mtdcJsonIO = function(_renkan, _opts) {
      var _proj = _renkan.project;
      if (typeof _opts.http_method === "undefined") {
          _opts.http_method = 'PUT';
      }
      var _load = function() {
          _proj.set({
              loadingStatus : true
          });
          Rkns.$.getJSON(_opts.url, function(_data) {
              _renkan.dataloader.load(_data);
              _proj.set({
                  loadingStatus : false,
              });
              _proj.set({
                  saveStatus : 0
              });
              _proj.on("add:nodes add:edges add:users add:views", function(_model) {
                  _model.on("change remove", function(_model) {
                      _thrSave();
                  });
                  _thrSave();
              });
              _proj.on("change", function() {
                  if (!(_proj.changedAttributes.length === 1 && _proj
                          .hasChanged('saveStatus'))) {
                      _thrSave();
                  }
              });
          }).fail(function(jqXHR, textStatus) {
              _showErrorModal(jqXHR);
          });
      };
      var _save = function() {
          _proj.set({
              saveStatus : 2
          });
          var _data = _proj.toJSON();
          if (!_renkan.read_only) {
              Rkns.$.ajax({
                  type : _opts.http_method,
                  url : _opts.url,
                  contentType : "application/json",
                  data : JSON.stringify(_data),
                  success : function(data, textStatus, jqXHR) {
                      _proj.set({
                          saveStatus : 0,
                          updated : data.updated
                      });
                  },
                  error: function (jqXHR, textStatus, errorThrown) {
                      _showErrorModal(jqXHR);
                  }
              });
          }

      };
      var _thrSave = Rkns._.throttle(function() {
          setTimeout(_save, 100);
      }, 1000);
      

      Rkns.$("#renkanErrorReload").on("click", function(){
         location.reload();
      });
      
      var errorModal = document.getElementById('renkanErrorModal');
      var _showErrorModal = function(jqXHR) {
          errorModal.style.display = "block";
          switch(jqXHR.status){
              case 400:
                  var jsonResp = JSONparse(jqXHR.responseText)
                  if(jsonResp.hasOwnAttribute('validation_timestamp')){
                      document.getElementById('400Error_timestamp').style.display = "block";
                  }
                  else {
                      Rkns.$("#400Error_other").append(jqXHR.responseText)
                      document.getElementById('400Error_other').style.display = "block";
                  }
                  break;
              case 403:
                  document.getElementById('403Error').style.display = "block";
                  break;
              case 404:
                  document.getElementById('404Error').style.display = "block";
                  break;
              case 500:
                  Rkns.$("#500Error").append(jqXHR.responseText)
                  document.getElementById('500Error').style.display = "block";
                  break;
          }
      }
      
      _load();
  };