
from allauth.socialaccount import providers
from allauth.socialaccount.providers.base import ProviderAccount
from allauth.socialaccount.providers.oauth2.provider import OAuth2Provider
from django.conf import settings

class MtdcProvider(OAuth2Provider):
    id = 'mtdc'
    name = 'MTDC'
    package = 'metaeducation.mtdc_oauth_provider'
    
    def extract_uid(self, data):
        return data.get(settings.MTDC_USERID_FIELD_NAME, "")

    def extract_common_fields(self, data):
        return {"username": data.get(settings.MTDC_USERNAME_FIELD_NAME, "")}

    def extract_extra_data(self, data):
        return {
            "username": data.get(settings.MTDC_USERNAME_FIELD_NAME, ""),
            "external_id": data.get(settings.MTDC_USERID_FIELD_NAME, ""),
            "uai": data.get(settings.MTDC_UAI_FIELD_NAME, ""),
            "first_name": data.get(settings.MTDC_FIRSTNAME_FIELD_NAME, ""),
            "last_name": data.get(settings.MTDC_LASTNAME_FIELD_NAME, "")
        }
    
providers.registry.register(MtdcProvider)