"""
Django settings for metaeducation project.

Generated by 'django-admin startproject' using Django 1.8.5.

For more information on this file, see
https://docs.djangoproject.com/en/1.8/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.8/ref/settings/
"""

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
import os

BASE_DIR = os.path.dirname(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))

# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/1.8/howto/deployment/checklist/

ALLOWED_HOSTS = []


# Application definition

INSTALLED_APPS = (
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django.contrib.sites',
    'allauth',
    'allauth.account',
    'allauth.socialaccount',
    'metaeducation.mtdc_oauth_provider',
    'guardian',
    'renkanmanager',
    'easy_thumbnails',
    'metaeducation'
)

AUTHENTICATION_BACKENDS = (
    'django.contrib.auth.backends.ModelBackend',
    'guardian.backends.ObjectPermissionBackend',
    'allauth.account.auth_backends.AuthenticationBackend',
)

REST_FRAMEWORK = {
    'DEFAULT_AUTHENTICATION_CLASSES': (
        'metaeducation.auth.MtdcOAuth2ClientCredentialsAuthentication',
        'rest_framework.authentication.BasicAuthentication',
        'renkanmanager.auth.CsrfExemptSessionAuthentication'
    ),
    'DEFAULT_PERMISSION_CLASSES': (
        'rest_framework.permissions.IsAuthenticatedOrReadOnly',
        #'rest_framework.permissions.DjangoObjectPermissions',
    ),
    'DEFAULT_PARSER_CLASSES': (
        'rest_framework.parsers.JSONParser',
    ),
    'DEFAULT_PAGINATION_CLASS': 'rest_framework.pagination.LimitOffsetPagination'
}

MIDDLEWARE_CLASSES = (
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.auth.middleware.SessionAuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'django.middleware.security.SecurityMiddleware','guardian.backends.ObjectPermissionBackend',
    'metaeducation.middleware.MtdcLoginRequiredWithContextMiddleware',
    'metaeducation.tracking.middleware.TrackingMiddleware',
)

ROOT_URLCONF = 'metaeducation.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [
            BASE_DIR+'/metaeducation/templates/'
        ],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

AUTH_USER_MODEL = 'metaeducation.User'

WSGI_APPLICATION = 'metaeducation.wsgi.application'

USE_I18N = True

USE_L10N = True

USE_TZ = True

SESSION_ENGINE = 'django.contrib.sessions.backends.signed_cookies'

# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.8/howto/static-files/
BASE_STATIC_ROOT = os.path.abspath(BASE_DIR + "../../web/static/").rstrip("/")+"/"
STATIC_ROOT = BASE_STATIC_ROOT + "site/"

LOGIN_URL = '/accounts/mtdc/login/'
OAUTH_EXEMPT_URLS = (
 r'^mtdc/accounts/',
 r'^accounts/',
 r'^api/',
 r'^admin/',
 r'^front/list'
 r'^front/delete/*'
)
# Guardian config

ANONYMOUS_USER_ID = -1

DEFAULT_RENKAN_ICON = ""
RENKAN_USER_DISPLAY_FIELD = 'external_id'

SOCIALACCOUNT_STORE_TOKENS = False
SOCIALACCOUNT_ADAPTER = "metaeducation.mtdc_oauth_provider.views.MtdcOAuth2Adapter"
SOCIALACCOUNT_PROVIDERS = {
    'mtdc': {
        'SCOPE': ['basic']
    }
}

MTDC_USERNAME_FIELD_NAME = "displayName"
MTDC_USERID_FIELD_NAME = "id"
MTDC_UAI_FIELD_NAME = "ENTPersonStructRattachUAI"
MTDC_FIRSTNAME_FIELD_NAME = "givenName"
MTDC_LASTNAME_FIELD_NAME = "sn"

ITOP_PF_CODE = "ITOP" # Parameter for the reference request, should be provided by Itop


ANONYMOUS_USER_ID = -1

DEFAULT_RENKAN_ICON = ""
RENKAN_TOOL_ID = ""

MTDC_CLIENT_ID = ""
MTDC_CLIENT_SECRET = ""
MTDC_AUTH_CODE = ""

MTDC_ACCESS_TOKEN_URL = "" # This URL is relative to a <CONTEXT> Base url that will be passed as query arg to the server
MTDC_AUTHORIZE_URL = "" # This URL is relative to a <CONTEXT> Base url that will be passed as query arg to the server
MTDC_PROFILE_URL = "" # This URL is relative to a <CONTEXT> Base url that will be passed as query arg to the server

MTDC_GED_BASE_URL = "" # Base URL of the GED server
MTDC_GED_REDIRECT_URI = "" # GED server redirect URI for token validation
MTDC_VALIDATE_TOKEN_BASE_URL = "" # "https://dev.enteduc.fr/rest/oauth/validate/"
MTDC_CLIENT_CREDENTIALS_TOKEN_URL = "" # "https://dev.enteduc.fr/oauth/oauth2/token"
MTDC_REFERENCE_RESOURCE_BASE_URL = MTDC_GED_BASE_URL + "" # "http://192.168.1.62:20411/ws/resource/" # MTDC_GED_BASE_URL + "/ws/resource/"
OAUTH_REDIRECT_URI = "" # Redirect URI for the GED server, when validating tokens

LRS_TRACKING_SERVICE_URL = "" # URL of the LRS to which we send tracking data
LRS_MTDC_RENKAN_USERNAME = "" # Username of Renkan app for LRS auth
LRS_MTDC_RENKAN_PASSWORD = "" # Password of Renkan app for LRS auth

TRACKING_URI_TEMPLATES = {
    'renkan': 'urn:mtdc:renkan:renkan:${renkan_id}',
    'node': 'urn:mtdc:renkan:node:${renkan_id}:${node_id}',
    'edge': 'urn:mtdc:renkan:edge:${renkan_id}:${edge_id}',
    'view': 'urn:mtdc:renkan:view:${renkan_id}:${view_id}'
}
