/* globals operative _ Cookies $ */
'use strict';

(function (root) {
    'use strict';

    if (typeof root.Mtdc !== 'object') {
        root.Mtdc = {};
    }

    var Mtdc = root.Mtdc;

    Mtdc.TrackingWorker = function (renkan, opts) {

        var options = _.defaults(opts, {
            debounceDelay: 1000,
            trackingUriTemplates: {
                'renkan': 'urn:mtdc:renkan:renkan:${renkan_id}',
                'node': 'urn:mtdc:renkan:node:${renkan_id}:${node_id}',
                'edge': 'urn:mtdc:renkan:edge:${renkan_id}:${edge_id}',
                'view': 'urn:mtdc:renkan:view:${renkan_id}:${view_id}'
            }
        });

        function _sendTrackingInfo() {
            var trackingMessages = this.trackingMessages;
            this.trackingMessages = [];
            if (trackingMessages.length === 0) {
                return;
            }
            $.ajax({
                method: 'POST',
                url: this.trackingUrl,
                headers: {
                    'X-CSRFToken': this.csrftoken
                },
                data: JSON.stringify(trackingMessages),
                contentType: 'application/json'
            }).fail(function () {
                console.log('send tracking data failed', trackingMessages);
            }); // this is fire and forget. Nothong to do on done
        }

        var trackingWorker = {
            trackingMessages: [],
            currentUser: renkan.current_user,
            renkan: renkan,
            trackingUrl: options.trackingUrl,
            trackingCloseUrl: options.trackingCloseUrl,
            getUUID4: function getUUID4() {
                return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
                    var r = Math.random() * 16 | 0,
                        v = c === 'x' ? r : r & 0x3 | 0x8;
                    return v.toString(16);
                });
            },
            _init: function _init() {
                this.sendTrackingInfo = _.debounce(_.bind(_sendTrackingInfo, this), options.debounceDelay);
                this.csrftoken = Cookies.get('csrftoken');
                this.registration = options.registration ? options.registration : this.getUUID4();
                this.trackingUriTemplates = _.mapValues(options.trackingUriTemplates, _.template);
                return this;
            },
            _pushTrackingMessage: function _pushTrackingMessage(msg) {
                this.trackingMessages.push(msg);
                this.sendTrackingInfo();
            },
            flushTrackingInfo: function flushTrackingInfo() {
                //this.sendTrackingInfo.flush();
            },
            _getBaseMsg: function _getBaseMsg(verb) {
                var timestamp = new Date(),
                    verbNode = ({
                    add: {
                        id: 'http://activitystrea.ms/schema/1.0/create',
                        display: { 'fr-FR': 'a créé' }
                    },
                    update: {
                        id: 'http://activitystrea.ms/schema/1.0/update',
                        display: { 'fr-FR': 'a modifié' }
                    },
                    'delete': {
                        id: 'http://activitystrea.ms/schema/1.0/delete',
                        display: { 'fr-FR': 'a supprimé' }
                    },
                    move: {
                        id: 'http://activitystrea.ms/schema/1.0/move',
                        display: { 'fr-FR': 'a déplacé' }
                    },
                    close: {
                        id: 'http://activitystrea.ms/schema/1.0/close',
                        display: { 'fr-FR': 'a fermé' }
                    },
                    search: {
                        id: 'http://activitystrea.ms/schema/1.0/search',
                        display: { 'fr-FR': 'a cherché' }
                    }

                })[verb];
                return {
                    actor: {
                        objectType: 'Agent',
                        name: this.currentUser,
                        account: {
                            homePage: 'https://www.metaeducation.fr/Utilisateurs/',
                            name: this.currentUser
                        }
                    },
                    verb: verbNode,
                    object: {
                        objectType: 'Activity'
                    },
                    context: {
                        registration: this.registration,
                        extensions: {
                            'http://liris.renkantracking.org/application': 'Outil carte mentale'
                        }
                    },
                    timestamp: timestamp.toISOString()
                };
            },
            _getObjectUri: function _getObjectUri(objectType, objectId) {
                var template = this.trackingUriTemplates[objectType];
                var templateParams = { 'renkan_id': this.renkan.project.get('id') };
                templateParams[objectType + '_id'] = objectId;
                return template(templateParams);
            },
            _sendNodeMsg: function _sendNodeMsg(verb, nodeData, changedData, previousData) {
                this._sendObjectMsg('node', 'http://www.w3.org/ns/activitystreams#Node', verb, nodeData, changedData, previousData);
            },
            _sendEdgeMsg: function _sendEdgeMsg(verb, nodeData, changedData, previousData) {
                this._sendObjectMsg('edge', 'http://www.w3.org/ns/activitystreams#Edge', verb, nodeData, changedData, previousData);
            },
            _sendViewMsg: function _sendViewMsg(verb, viewData, changedData, previousData) {
                this._sendObjectMsg('view', 'http://www.w3.org/ns/activitystreams#View', verb, viewData, changedData, previousData);
            },
            _sendObjectMsg: function _sendObjectMsg(objectType, objectTypeUrl, verb, objData, changedData, previousData) {

                var msg = this._getBaseMsg(verb);

                msg.object = _.merge(msg.object, {
                    id: this._getObjectUri(objectType, objData._id), //TODO full url ???
                    definition: {
                        name: {
                            'fr-FR': objData.title
                        },
                        description: {
                            'fr-FR': objData.description
                        },
                        type: objectTypeUrl,
                        extensions: {
                            'http://www.w3.org/ns/activitystreams#Data': objData,
                            'http://www.w3.org/ns/activitystreams#DataChanged': changedData, //this part are not sent if undefined
                            'http://www.w3.org/ns/activitystreams#DataPrevious': previousData //this part are not sent if undefined
                        }
                    }
                });
                msg.context = _.merge(msg.context, {
                    extensions: {
                        'http://liris.renkantracking.org/fromCreate': objData.origin
                    }
                });

                this._pushTrackingMessage(msg);
            },
            addNode: function addNode(nodeData) {
                this._sendNodeMsg('add', nodeData);
            },
            deleteNode: function deleteNode(nodeData) {
                this._sendNodeMsg('delete', nodeData);
            },
            updateNode: function updateNode(nodeData, changedData, previousData) {
                if ('position' in changedData) {
                    this._sendNodeMsg('move', nodeData, { position: changedData['position'] }, { position: previousData['position'] });
                    delete changedData['position'];
                    delete previousData['position'];
                }
                if (_.isEmpty(changedData)) {
                    return;
                }
                this._sendNodeMsg('update', nodeData, changedData, previousData);
            },
            addEdge: function addEdge(edgeData) {
                this._sendEdgeMsg('add', edgeData);
            },
            deleteEdge: function deleteEdge(edgeData) {
                this._sendEdgeMsg('delete', edgeData);
            },
            updateEdge: function updateEdge(edgeData, changedData, previousData) {
                this._sendEdgeMsg('update', edgeData, changedData, previousData);
            },
            addView: function addView(edgeData) {
                this._sendViewMsg('add', edgeData);
            },
            deleteView: function deleteView(edgeData) {
                this._sendViewMsg('delete', edgeData);
            },
            updateView: function updateView(viewData, changedData, previousData) {
                this._sendViewMsg('update', viewData, changedData, previousData);
            },
            searchProject: function searchProject(searchData) {
                var msg = this._getBaseMsg('search');

                msg.object = _.merge(msg.object, {
                    id: this._getObjectUri('renkan', this.renkan.project.get('id')),
                    definition: {
                        name: {
                            'fr-FR': this.renkan.project.get('title')
                        },
                        type: 'http://www.w3.org/ns/activitystreams#Renkan',
                        extensions: {
                            'http://www.w3.org/ns/activitystreams#Data': searchData
                        }
                    }
                });
                this._pushTrackingMessage(msg);
            },
            closeProject: function closeProject() {
                this.flushTrackingInfo();
                $.ajax({
                    method: 'POST',
                    url: this.trackingCloseUrl,
                    async: false,
                    headers: {
                        'X-CSRFToken': this.csrftoken
                    },
                    data: {
                        'renkan_guid': this.renkan.project.get('id'),
                        'registration': this.registration
                    }
                }).fail(function () {
                    console.log('send tracking data failed');
                }); // this is fire and forget. Nothong tpo do on failed
            }

        };

        return trackingWorker._init();
    };
})(window);
/* eslint no-console: 0 */