from django.contrib.auth import authenticate, login, logout
from django.core.urlresolvers import reverse
from django.http import HttpResponse, HttpResponseRedirect
from django.shortcuts import render, get_object_or_404
from django.views.decorators.csrf import csrf_exempt
from django.views.generic import TemplateView, View
from rest_framework.renderers import TemplateHTMLRenderer

from renkanmanager.models import Renkan
from renkanmanager.serializers import RenkanSerializer
from renkanmanager.api.views import RenkanDetail

class ListRenkansView(View):
    template_name = "renkan_list.html"
    
    def get(self, request):
        renkans = Renkan.objects.filter(creator=request.user)
        return render(request, self.template_name, {'renkans': renkans})  
      
    def post(self, request):
        create_data = {
            "title" : request.POST.get("title", "Untitled Renkan")
        }
        
        serializer = RenkanSerializer(data=create_data)
        if serializer.is_valid():
            serializer.save(creator=request.user)
        return HttpResponseRedirect(request.META.get('HTTP_REFERER', '/'))

class NewRenkanView(View):
    
    def get(self, request):
        create_data = {
            "title" : "Untitled Renkan"
        }
        serializer = RenkanSerializer(data=create_data)
        if serializer.is_valid():
            new_renkan = serializer.save(creator=request.user)
            return HttpResponseRedirect(reverse("front_edit_renkan", kwargs={"renkan_guid": new_renkan.renkan_guid}))
        

class ViewRenkanView(TemplateView):
    template_name = "renkan_view.html"


class EditRenkanView(TemplateView):
    template_name = "renkan_edit.html"
    

class DeleteRenkanView(View):
    def get(self, request, renkan_guid):
        request.method = "DELETE"
        delete_response = RenkanDetail.as_view()(request, renkan_guid)
        return HttpResponseRedirect(request.META.get('HTTP_REFERER', '/')) 
        