from django.shortcuts import redirect
from django.conf import settings
from urllib.parse import urlencode
from re import compile

EXEMPT_URLS = [compile(settings.LOGIN_URL.lstrip('/'))]
if hasattr(settings, 'LOGIN_EXEMPT_URLS'):
    EXEMPT_URLS += [compile(expr) for expr in settings.LOGIN_EXEMPT_URLS]

class MtdcLoginRequiredWithContextMiddleware:
    """
    Middleware intended to emulate login_required decorator so we can forward the context query arg
    """
    def process_request(self, request):
        if not request.user.is_authenticated():
            path = request.path_info.lstrip('/')
            if not any(m.match(path) for m in EXEMPT_URLS):
                if request.GET.get("context", ""):
                    context = request.GET["context"]
                    response = redirect(settings.LOGIN_URL)
                    response["LOCATION"] += "?"+urlencode({"context": context, "next": "/"+path})
                    return response
