from django.db.models.signals import post_save
from django.dispatch import receiver
from django.contrib.auth import get_user_model
from django.conf import settings
from django.core.urlresolvers import reverse
import requests, json, sys

def reference_created_renkan(sender, instance, created, **kwargs):
    from renkanmanager.models import Renkan
    if created and sender == Renkan and not instance.source_revision_guid:
        token_response = requests.post(
            settings.MTDC_CLIENT_CREDENTIALS_TOKEN_URL+"?grant_type=client_credentials",
            data = {},
            headers = {
                "Authorization": "Basic %s" % settings.MTDC_AUTH_CODE
            }          
        )
        if token_response.status_code == 200:
            token = json.loads(token_response.text)['access_token']
            post_data = json.dumps({
                "id": str(instance.renkan_guid),
                "idOutil": settings.RENKAN_TOOL_ID,
                "idUser": instance.creator.external_id,
                "pf": settings.ITOP_PF_CODE,
                "uai": instance.creator.uai,
                "redirect_uri": settings.OAUTH_REDIRECT_URI,
                "title": instance.title
            })
            resource_ws_url = settings.MTDC_REFERENCE_RESOURCE_BASE_URL# + str(instance.renkan_guid)
            
            reference_response = requests.post(
                resource_ws_url,
                data = post_data,
                headers = {
                    "Authorization": "Bearer %s" % token,
                    "content-type": "application/json"
                }                             
            )
            

if not 'test' in sys.argv:
    post_save.connect(reference_created_renkan)