from urllib import parse

import requests, re, json, logging

from django.conf import settings
from django.contrib.auth import get_user_model, login
from django.contrib.auth.models import Permission
from rest_framework.authentication import BaseAuthentication


logger = logging.getLogger(__name__)

class MtdcOAuth2ClientCredentialsAuthentication(BaseAuthentication):
    
    def authenticate(self, request):
        # get token, get username
        if ("act_as" not in request.GET) and ('HTTP_RENKAN_ACT_AS' not in request.META):
            logger.debug("CLIENT CREDENTIAL AUTH: no act_as, not client credentials")
            return
        else:
            external_id = request.GET.get('act_as', request.META.get("HTTP_RENKAN_ACT_AS", ""))
        try: 
            user = get_user_model().objects.get(external_id=external_id)
        except get_user_model().DoesNotExist:
            logger.debug("CLIENT CREDENTIAL AUTH: User does not exist, abort")
            return
        if 'HTTP_AUTHORIZATION' not in request.META:
            logger.debug("CLIENT CREDENTIAL AUTH: no token, abort")
            return
        else:
            token = re.search("(?<=\s).*", request.META["HTTP_AUTHORIZATION"]).group(0)
            logger.debug("CLIENT CREDENTIAL AUTH: token is "+token)
        # send token to Oauth server
        token_validate_response = requests.get(
            settings.MTDC_VALIDATE_TOKEN_BASE_URL+token+"?redirect_uri="+parse.quote_plus(settings.MTDC_GED_BASE_URL)
        )
        if token_validate_response.status_code != 200:
            logger.debug("CLIENT CREDENTIAL AUTH: token validate failed, abort")
            return
        logger.debug("CLIENT CREDENTIAL AUTH: user "+external_id+" is authenticated by token "+token+", auth success")
        return (user, None)
    
