# -*- coding: utf-8 -*-
# Generated by Django 1.9.1 on 2016-04-11 13:24
from __future__ import unicode_literals

from django.db import migrations
from django.contrib.auth import get_user_model
from django.contrib.auth.models import Permission

def fix_renkan_permissions(apps, schema_editor):
    User = get_user_model()
    for user in User.objects.all():
        for perm in ["view_renkan", "add_renkan", "change_renkan", "delete_renkan", "add_revision", "delete_revision"]:
            if not user.has_perm(perm):
                perm_obj = Permission.objects.get(codename=perm)
                user.user_permissions.add(perm_obj)
        user.save()

class Migration(migrations.Migration):

    dependencies = [
        ('metaeducation', '0002_user_uai'),
    ]

    operations = [
        migrations.RunPython(fix_renkan_permissions)
    ]
