import logging
from django.conf import settings
from django.http import HttpResponse
from django.views.generic import View
from django import forms
from django.shortcuts import get_object_or_404

from metaeducation.tracking import send_tracking_data, send_close_renkan
from renkanmanager.models import Renkan

logger = logging.getLogger(__name__)

class UITrackingView(View):

    def post(self, request):
        logger.debug("POSTING DATA %r", str(request.body, 'utf-8'))

        send_tracking_data.delay(str(request.body, 'utf-8'))

        # This is a fire and forget !!!
        # please track the log to see if everything is ok
        return HttpResponse(status=204)

class RenkanCloseForm(forms.Form):
    renkan_guid = forms.UUIDField()
    registration = forms.UUIDField()


class UITrackingViewClose(View):
    def post(self, request):
        renkan_close_form = RenkanCloseForm(request.POST)
        if renkan_close_form.is_valid():
            form_data = renkan_close_form.cleaned_data
            renkan = get_object_or_404(Renkan.objects.select_related('current_revision'), renkan_guid=form_data['renkan_guid'])
            send_close_renkan(renkan, request.user, str(form_data['registration']))
            return HttpResponse(status=204)
        else:
            return HttpResponse(status=400)
