/* Saves the Full JSON at each modification */

Rkns.mtdcJsonIO = function(_renkan, _opts) {
      var _proj = _renkan.project;
      if (typeof _opts.http_method === "undefined") {
          _opts.http_method = 'PUT';
      }
      var _load = function() {
          _proj.set({
              loadingStatus : true
          });
          Rkns.$.getJSON(_opts.url, function(_data) {
              _renkan.dataloader.load(_data);
              _proj.set({
                  loadingStatus : false,
              });
              _proj.set({
                  saveStatus : 0
              });
              console.log(_proj.get("updated"))
              _proj.on("add:nodes add:edges add:users add:views", function(_model) {
                  _model.on("change remove", function(_model) {
                      _thrSave();
                  });
                  _thrSave();
              });
              _proj.on("change", function() {
                  if (!(_proj.changedAttributes.length === 1 && _proj
                          .hasChanged('saveStatus'))) {
                      _thrSave();
                  }
              });
          }).fail(function( jqXHR, textStatus ) {
              _showErrorModal(jqXHR.responseText);
              console.log(textStatus)
          });
      };
      var _save = function() {
          _proj.set({
              saveStatus : 2
          });
          var _data = _proj.toJSON();
          if (!_renkan.read_only) {
              Rkns.$.ajax({
                  type : _opts.http_method,
                  url : _opts.url,
                  contentType : "application/json",
                  data : JSON.stringify(_data),
                  success : function(data, textStatus, jqXHR) {
                      _proj.set({
                          saveStatus : 0,
                          updated : data.updated
                      });
                      //_showErrorModal("updated")
                  },
                  error: function (jqXHR, textStatus, errorThrown) {
                      _showErrorModal(jqXHR.responseText);
                      console.log(textStatus)
                      console.log(errorThrown)
                  }
              });
          }

      };
      var _thrSave = Rkns._.throttle(function() {
          setTimeout(_save, 100);
      }, 1000);
      

      Rkns.$("#renkanErrorReload").on("click", function(){
         location.reload();
      });
      
      var errorModal = document.getElementById('renkanErrorModal');
      var _showErrorModal = function(message) {
          errorModal.style.display = "block";
          Rkns.$(".errorMsg").text(message);
      }
      
      _load();
  };