/* This widget displays the image associated to the annotation in the given container */
// ImageDisplay
import imageDisplayStyles from "./ImageDisplay.module.css";

const ImageDisplay = function (ns) {
  return class extends ns.Widgets.Widget {
    constructor(player, config) {
      super(player, config);
    }

    static defaults = {
      annotation_type: "Slides",
      // container: "imageContainer"
    };

    static template =
      '<div class="Ldt-ImageDisplay-Container"><div class="Ldt-ImageDisplay-Overlay Ldt-ImageDisplay-Overlay-Left"></div><div class="Ldt-ImageDisplay-Overlay Ldt-ImageDisplay-Overlay-Right"></div></div>';

    annotationTemplate = "";

    update(annotation) {
      // Update the widget with data corresponding to the annotation
      this.image.css("background-image", "url(" + annotation.thumbnail + ")");
      this.image.attr(
        "title",
        ns.textFieldHtml(annotation.title) + " - " + annotation.begin.toString()
      );
    }

    draw() {
      var _annotations = this.getWidgetAnnotations().sortBy(function (
        _annotation
      ) {
        return _annotation.begin;
      });
      var _this = this;
      _this.renderTemplate();
      _this.image = _this.$.find(".Ldt-ImageDisplay-Container");

      _this.$.find(".Ldt-ImageDisplay-Overlay-Left").on("click", function () {
        _this.navigate(-1);
      });
      _this.$.find(".Ldt-ImageDisplay-Overlay-Right").on("click", function () {
        _this.navigate(+1);
      });

      _annotations.forEach(function (_a) {
        _a.on("enter", function () {
          _this.update(_a);
        });
      });
      if (_annotations.length) _this.update(_annotations[0]);
    }
  };
};

export { ImageDisplay, imageDisplayStyles };
