/* widgets-container/metadataplayer.js - initialization and configuration of the widgets
 */

/* The Metadataplayer Object, single point of entry, replaces IriSP.init_player */
import _ from "lodash";
import jQuery from "jquery";

export default function (ns) {
  var formerJQuery, formerUnderscore, former$;

  var Metadataplayer = (ns.Metadataplayer = function (config) {
    ns.log("IriSP.Metadataplayer constructor");
    for (var key in ns.guiDefaults) {
      if (ns.guiDefaults.hasOwnProperty(key) && !config.hasOwnProperty(key)) {
        config[key] = ns.guiDefaults[key];
      }
    }
    var _container = document.getElementById(config.container);
    _container.innerHTML =
      '<h3 class="Ldt-Loader">Loading... Chargement...</h3>';
    this.sourceManager = new ns.Model.Directory();
    this.config = config;
    this.__events = {};
    //this.loadLibs();
    this.onLibsLoaded();
  });

  Metadataplayer.prototype.toString = function () {
    return "Metadataplayer in #" + this.config.container;
  };

  Metadataplayer.prototype.on = function (_event, _callback) {
    if (typeof this.__events[_event] === "undefined") {
      this.__events[_event] = [];
    }
    this.__events[_event].push(_callback);
  };

  Metadataplayer.prototype.trigger = function (_event, _data) {
    var _element = this;
    _(this.__events[_event]).each(function (_callback) {
      _callback.call(_element, _data);
    });
  };

  Metadataplayer.prototype.onLibsLoaded = function () {
    ns.log("IriSP.Metadataplayer.prototype.onLibsLoaded");

    // if (
    //   typeof jQuery === "undefined" &&
    //   typeof window.jQuery !== "undefined"
    // ) {
    //   jQuery = window.jQuery;
    //   if (former$ || formerJQuery) {
    //     window.jQuery.noConflict(formerJQuery);
    //   }
    // }
    // if (typeof _ === "undefined" && typeof window._ !== "undefined") {
    //   _ = window._;
    //   if (formerUnderscore) {
    //     _.noConflict();
    //   }
    // }

    this.$ = jQuery("#" + this.config.container);
    this.$.css({
      width: this.config.width,
      clear: "both",
    });
    if (typeof this.config.height !== "undefined") {
      this.$.css("height", this.config.height);
    }

    this.widgets = [];
    var _this = this;
    _(this.config.widgets).each(function (widgetconf, key) {
      _this.widgets.push(null);
      _this.loadWidget(widgetconf, function (widget) {
        _this.widgets[key] = widget;
        if (widget.isLoaded()) {
          _this.trigger("widget-loaded");
        }
      });
    });
    this.$.find(".Ldt-Loader").detach();

    this.widgetsLoaded = false;

    this.on("widget-loaded", function () {
      if (_this.widgetsLoaded) {
        return;
      }
      var isloaded = !_(_this.widgets).some(function (w) {
        return !(w && w.isLoaded());
      });
      if (isloaded) {
        _this.widgetsLoaded = true;
        _this.trigger("widgets-loaded");
      }
    });
  };

  Metadataplayer.prototype.loadLocalAnnotations = function (
    localsourceidentifier
  ) {
    if (this.localSource === undefined)
      this.localSource = this.sourceManager.newLocalSource({
        serializer: IriSP.serializers["ldt_localstorage"],
      });
    // Load current local annotations
    if (localsourceidentifier) {
      // Allow to override localsourceidentifier when necessary (usually at init time)
      this.localSource.identifier = localsourceidentifier;
    }
    this.localSource.deSerialize(
      window.localStorage[this.localSource.identifier] || "[]"
    );
    return this.localSource;
  };

  Metadataplayer.prototype.saveLocalAnnotations = function () {
    // Save annotations back to localstorage
    window.localStorage[this.localSource.identifier] =
      this.localSource.serialize();
    // Merge modifications into widget source
    // this.source.merge(this.localSource);
  };

  Metadataplayer.prototype.addLocalAnnotation = function (a) {
    this.loadLocalAnnotations();
    this.localSource.getAnnotations().push(a);
    this.saveLocalAnnotations();
  };

  Metadataplayer.prototype.deleteLocalAnnotation = function (ident) {
    this.localSource.getAnnotations().removeId(ident, true);
    this.saveLocalAnnotations();
  };

  Metadataplayer.prototype.getLocalAnnotation = function (ident) {
    this.loadLocalAnnotations();
    // We cannot use .getElement since it fetches
    // elements from the global Directory
    return _.first(
      _.filter(this.localSource.getAnnotations(), function (a) {
        return a.id == ident;
      })
    );
  };

  Metadataplayer.prototype.loadMetadata = function (_metadataInfo) {
    if (_metadataInfo.elementType === "source") {
      return _metadataInfo;
    }
    if (
      typeof _metadataInfo.serializer === "undefined" &&
      typeof _metadataInfo.format !== "undefined"
    ) {
      _metadataInfo.serializer = ns.serializers[_metadataInfo.format];
    }
    if (
      typeof _metadataInfo.url !== "undefined" &&
      typeof _metadataInfo.serializer !== "undefined"
    ) {
      return this.sourceManager.remoteSource(_metadataInfo);
    } else {
      return this.sourceManager.newLocalSource(_metadataInfo);
    }
  };

  Metadataplayer.prototype.loadWidget = function (_widgetConfig, _callback) {
    /* Creating containers if needed */
    if (typeof _widgetConfig.container === "undefined") {
      var _divs = this.layoutDivs(_widgetConfig.type);
      _widgetConfig.container = _divs[0];
    }

    var _this = this;

    if (typeof ns.Widgets[_widgetConfig.type] !== "undefined") {
      _.defer(function () {
        _callback(new ns.Widgets[_widgetConfig.type](_this, _widgetConfig));
      });
    } else {
      ns.log("Widget type " + _widgetConfig.type + " Unkown !");
    }
  };

  /** create a subdiv with an unique id, and a spacer div as well.
    @param widgetName the name of the widget.
    @return an array of the form [createdivId, spacerdivId].
*/
  Metadataplayer.prototype.layoutDivs = function (_name, _height) {
    if (typeof _name === "undefined") {
      _name = "";
    }
    var newDiv = _.uniqueId(this.config.container + "_widget_" + _name + "_"),
      spacerDiv = _.uniqueId("LdtPlayer_spacer_"),
      divHtml = jQuery("<div>")
        .attr("id", newDiv)
        .css({
          width: this.config.width + "px",
          position: "relative",
          clear: "both",
        }),
      spacerHtml = jQuery("<div>")
        .attr("id", spacerDiv)
        .css({
          width: this.config.width + "px",
          height: this.config.spacer_div_height + "px",
          position: "relative",
          clear: "both",
        });
    if (typeof _height !== "undefined") {
      divHtml.css("height", _height);
    }

    this.$.append(divHtml);
    this.$.append(spacerHtml);

    return [newDiv, spacerDiv];
  };
}

/* End of widgets-container/metadataplayer.js */
