/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.commonjs.module.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.commonjs.module.ModuleScript;
import org.mozilla.javascript.commonjs.module.provider.CachingModuleScriptProviderBase;
import org.mozilla.javascript.commonjs.module.provider.ModuleSourceProvider;
import org.mozilla.javascript.edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import org.mozilla.javascript.edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;

public class SoftCachingModuleScriptProvider
extends CachingModuleScriptProviderBase {
    private static final long serialVersionUID = 1L;
    private transient ReferenceQueue<Script> scriptRefQueue = new ReferenceQueue();
    private transient ConcurrentMap<String, ScriptReference> scripts = new ConcurrentHashMap(16, 0.75f, SoftCachingModuleScriptProvider.getConcurrencyLevel());

    public SoftCachingModuleScriptProvider(ModuleSourceProvider moduleSourceProvider) {
        super(moduleSourceProvider);
    }

    public ModuleScript getModuleScript(Context cx, String moduleId, URI uri, Scriptable paths) throws Exception {
        ScriptReference ref;
        while ((ref = (ScriptReference)this.scriptRefQueue.poll()) != null) {
            this.scripts.remove((Object)ref.getModuleId(), (Object)ref);
        }
        return super.getModuleScript(cx, moduleId, uri, paths);
    }

    protected CachingModuleScriptProviderBase.CachedModuleScript getLoadedModule(String moduleId) {
        ScriptReference scriptRef = (ScriptReference)this.scripts.get((Object)moduleId);
        return scriptRef != null ? scriptRef.getCachedModuleScript() : null;
    }

    protected void putLoadedModule(String moduleId, ModuleScript moduleScript, Object validator) {
        this.scripts.put(moduleId, new ScriptReference(moduleScript.getScript(), moduleId, moduleScript.getUri(), moduleScript.getBase(), validator, this.scriptRefQueue));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.scriptRefQueue = new ReferenceQueue();
        this.scripts = new ConcurrentHashMap();
        Map serScripts = (Map)in.readObject();
        Iterator i$ = serScripts.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry entry = i$.next();
            CachingModuleScriptProviderBase.CachedModuleScript cachedModuleScript = (CachingModuleScriptProviderBase.CachedModuleScript)entry.getValue();
            this.putLoadedModule((String)entry.getKey(), cachedModuleScript.getModule(), cachedModuleScript.getValidator());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        HashMap serScripts = new HashMap();
        Iterator i$ = this.scripts.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry entry = i$.next();
            CachingModuleScriptProviderBase.CachedModuleScript cachedModuleScript = ((ScriptReference)entry.getValue()).getCachedModuleScript();
            if (cachedModuleScript == null) continue;
            serScripts.put(entry.getKey(), cachedModuleScript);
        }
        out.writeObject(serScripts);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScriptReference
    extends SoftReference<Script> {
        private final String moduleId;
        private final URI uri;
        private final URI base;
        private final Object validator;

        ScriptReference(Script script, String moduleId, URI uri, URI base, Object validator, ReferenceQueue<Script> refQueue) {
            super(script, refQueue);
            this.moduleId = moduleId;
            this.uri = uri;
            this.base = base;
            this.validator = validator;
        }

        CachingModuleScriptProviderBase.CachedModuleScript getCachedModuleScript() {
            Script script = (Script)this.get();
            if (script == null) {
                return null;
            }
            return new CachingModuleScriptProviderBase.CachedModuleScript(new ModuleScript(script, this.uri, this.base), this.validator);
        }

        String getModuleId() {
            return this.moduleId;
        }
    }
}

