// AutoPlayer

const AutoPlayer = function (ns) {
  return class extends ns.Widgets.Widget {
    constructor(player, config) {
      super(player, config);
    }

    static defaults = {
      default_type: "HtmlPlayer",
    };

    draw() {
      if (typeof this.video === "undefined") {
        this.video = this.media.video;
      }

      var _props = [
          "live",
          "provider",
          "autostart",
          "streamer",
          "video",
          "height",
          "width",
          "url_transform",
          "dailymotionPlayerId"
        ],
        _opts = {},
        _types = [
          {
            regexp: /\.(mp4|m4v|mp3)$/,
            type: "AdaptivePlayer",
          },
          {
            regexp: /\.(ogg|ogv|webm)$/,
            type: "HtmlPlayer",
          },
          {
            regexp: /^(https?:\/\/)?(www\.)?youtube\.com/,
            type: "VideojsPlayer",
          },
          {
            regexp: /^(https?:\/\/)?(www\.)?vimeo\.com/,
            type: "VideojsPlayer",
          },
          {
            regexp: /^(https?:\/\/)?(www\.)?dailymotion\.com/,
            type: "VideojsPlayer",
          },
        ]

      if(this.video) {
        for (var i = 0; i < _types.length; i++) {
          if (_types[i].regexp.test(this.video.toLowerCase())) {
            _opts.type = _types[i].type;
            break;
          }
        }
      }

      if (typeof _opts.type === "undefined") {
        _opts.type = this.default_type;
      }

      if (_opts.type === "AdaptivePlayer") {
        var _canPlayType = document
          .createElement("video")
          .canPlayType('video/mp4; codecs="avc1.42E01E"');
        _opts.type = _canPlayType !== "no" ? "HtmlPlayer" : "JwpPlayer";
      }

      for (var i = 0; i < _props.length; i++) {
        if (typeof this[_props[i]] !== "undefined") {
          _opts[_props[i]] = this[_props[i]];
        }
      }

      this.insertSubwidget(this.$, _opts);
    };
  };
};

export { AutoPlayer };
