import { defineConfig } from "vite";
import banner from "vite-plugin-banner";
import pkg from "./package.json";
import { nodePolyfills } from "vite-plugin-node-polyfills";
import inject from '@rollup/plugin-inject';

export default defineConfig({
  build: {
    lib: {
      // Could also be a dictionary or array of multiple entry points
      entry: "./src/main.js",
      name: "MetadataPlayer",
      // the proper extensions will be added
      fileName: (format) => {
        if(format == "es")
          return "LdtPlayer-core.lib.js"
        else
          return "LdtPlayer-core.js";
        },
      type: ["es", "cjs", "umd"],
    },
    rollupOptions: {
      // make sure to externalize deps that shouldn't be bundled
      // into your library
      external: [],
      output: {
        // Provide global variables to use in the UMD build
        // for externalized deps
        globals: {},
        assetFileNames: "LdtPlayer-core.[ext]",
      },
    },
    define: {
      __APP_VERSION__: JSON.stringify(process.env.npm_package_version),
    },
    copyPublicDir: false,
    sourcemap: true,
  },
  css: {
    modules: {
      scopeBehaviour: "global",
      //      localsConvention: "camelCaseOnly"
    },
  },
  plugins: [
    {
      ...inject({
        $: 'jquery',
        jQuery: 'jquery',
      }),
      enforce:"post",
    },
    banner(`
   *
    __  __      _            _       _              _                       
   |  \\/  | ___| |_ __ _  __| | __ _| |_ __ _ _ __ | | __ _ _   _  ___ _ __ 
   | |\\/| |/ _ \\ __/ _\` |/ _\` |/ _\` | __/ _\` | '_ \\| |/ _\` | | | |/ _ \\ '__|
   | |  | |  __/ || (_| | (_| | (_| | || (_| | |_) | | (_| | |_| |  __/ |   
   |_|  |_|\\___|\\__\\__,_|\\__,_|\\__,_|\\__\\__,_| .__/|_|\\__,_|\\__, |\\___|_|   
                                             |_|            |___/         
   
   *  Copyright 2010-2024 Institut de Recherche et d'Innovation 
   *  contributor(s) : Karim Hamidou, Samuel Huron, Raphael Velt, Thibaut Cavalie, Yves-Marie Haussonne, Nicolas Durand, Olivier Aubert
   *   
   *  contact@iri.centrepompidou.fr
   *  http://www.iri.centrepompidou.fr 
   *   
   *  This software is a computer program whose purpose is to show and add annotations on a video .
   *  This software is governed by the CeCILL-C license under French law and
   *  abiding by the rules of distribution of free software. You can  use, 
   *  modify and/ or redistribute the software under the terms of the CeCILL-C
   *  license as circulated by CEA, CNRS and INRIA at the following URL
   *  "http://www.cecill.info". 
   *  
   *  The fact that you are presently reading this means that you have had
   *  knowledge of the CeCILL-C license and that you accept its terms.
   *  ${pkg.name} - version ${pkg.version}
 `),
    nodePolyfills(),
  ],
});
