﻿package bab
{
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.net.FileReference;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.system.Capabilities;
	import player_bab_ldt;
	
	public class XMLInOut
	{
		private var app:player_bab_ldt;
		
		private var myLdtEdits:XMLList;
		private var editsAr:Array = [];
		private var titlesAr:Array = [];
		private var nbBab:uint = 0;
		private var curBab:Number = -1;
		private var segAr1:Array;
		private var segAr2:Array;
		
		public function XMLInOut(o:player_bab_ldt, urlData:String)
		{
			app = o;
			var urll:URLLoader = new URLLoader(new URLRequest(urlData)); 
			urll.addEventListener(Event.COMPLETE, onloadData);
			urll.addEventListener(IOErrorEvent.IO_ERROR, errorLoad);
		}
		
		private function errorLoad(e:IOErrorEvent):void{
			trace("errorLoad");
			//Alert.show("Impossible to load the file") + " " + e.text + "\n" + (e.target as URLLoaderLdt).url, "Error");
		}
		
		
		private function onloadData(e:Event):void{
			
			var ldtXml:XML = new XML(e.currentTarget.data);
			// We test if the project is in old iri/ldt format or cinelab format
			if(ldtXml.project.length()>0){
				// There is a project tag in the xml -> iri/ldt format
				myLdtEdits = ldtXml.edits.editing;
				loadEditsXML(myLdtEdits);
   			}
   			else{
				// Else cinelab format 
				trace("No LDT format, No load");
				//Alert.show("No LDT format","No load");
   			}
            
		}
		public function loadEditsXML(xl:XMLList):void{
			trace("loadEditsXML l = " + xl.length() + ", nodename = " + xl[0].name().localName);
			if(xl!=null && xl.length()>0){
				if(xl[0].name().localName=="view"){
					//loadEditsXMLCinelab(xl);
					trace("No BAB LDT format, No load");
				}
				else{
					//trace(xl.toString());
					editsAr = new Array();
					titlesAr = new Array();
					for each(var editing:XML in xl){
						nbBab++;
						var inst:XML, curMedia:XMLList, a:Array, content:String;
						// First edit's line
						var ar1:Array = new Array();
						var editList:XMLList = editing.edit.(@id=="edit1").eList.inst;
						var mediaList:XMLList = editing.edit.(@id=="edit1").mList.m;
						// We adapt the program to the new and old version of content/media place
						// new <m ref="kia_closeup" id="0" t="v" c="color_uint"><content>url or text content</content></m>
						// old <m ref="kia_closeup" id="0" t="v" c="color_or_quality" src="path/media_or_pict.flv"><content/></m>
						for each(inst in editList){
							a = inst.@ref.split("|;|");
							curMedia = mediaList.(@id==inst.@m);
							content = (curMedia.@src.toString()=="" || curMedia.@src==undefined) ? curMedia.content.toString() : curMedia.@src.toString();
							//trace("m = " + inst.@m.toString() + ", " + curMedia.@t.toString() + ", " + uint(curMedia.@c) + ", " + curMedia.@src.toString() + ", " + curMedia.content.toString() + ", content=" + content);
							if(a[0]=="title"){ a[0]="text"; } // To allow old version
							// A video path can be dependant on the user's folder organisation.
							// If a user B receives a project from a user A, the video paths will be like
							// /users/userA/docs/video/id/id.flv and /users/userB/ldt/id/i	d.flv
							// So in order ta read the BàB without problems, we match the bàb paths
							// with the video paths actually recorded.
//							if(curMedia.@t.toString()=="v"){
//								content = content.replace(/\\/g,"/");
//								var videoName:String = content.substr(content.lastIndexOf("/")+1);
//								for(var idCtt:String in Global.arContents){
//									if(Global.arContents[idCtt]["path"].substr(Global.arContents[idCtt]["path"].replace(/\\/g,"/").lastIndexOf("/")+1)==videoName){
//										content = Global.arContents[idCtt]["path"];
//									}
//								}
//							}
							// Now that we got the good video path, we push in the array
							ar1.push({idCtt:a[0], idGrp:a[1], idCut:a[2], idView:a[3], crit:a[3], idSeg:a[5], tIn:Number(inst.@begin), tOut:Number(inst.@end), type:curMedia.@t.toString(), v:uint(inst.@v), color:uint(curMedia.@c), content:content, idAuthor:"", author:"", idTitle:"", title:"", date:"", trId:Number(inst.@trId), trIc:Number(inst.@trIc), trOd:Number(inst.@trOd), trOc:Number(inst.@trOc)});
						}
						
						// Second edit's line
						var ar2:Array = new Array();
						editList = editing.edit.(@id=="edit2").eList.inst;
						mediaList = editing.edit.(@id=="edit2").mList.m;
						for each(inst in editList){
							a = inst.@ref.split("|;|");
							//trace("m = " + inst.@m.toString() + ", " + edit1Media.(@id==inst.@m.toString()).@t.toString() + ", " + uint(edit1Media.(@id==inst.@m).@c) + ", " + edit1Media.(@id==inst.@m).@src.toString() + ", " + edit1Media.(@id==inst.@m).content.toString());
							curMedia = mediaList.(@id==inst.@m);
							content = (curMedia.@src.toString()=="" || curMedia.@src==undefined) ? curMedia.content.toString() : curMedia.@src.toString();
							if(a[0]=="title"){ a[0]="text"; } // To allow old version
							// A video path can be dependant on the user's folder organisation.
							// If a user B receives a project from a user A, the video paths will be like
							// /users/userA/docs/video/id/id.flv and /users/userB/ldt/id/id.flv
							// So in order ta read the BàB without problems, we match the bàb paths
							// with the video paths actually recorded.
//							if(curMedia.@t.toString()=="v"){
//								content = content.replace(/\\/g,"/");
//								videoName = content.substr(content.lastIndexOf("/")+1);
//								for(idCtt in Global.arContents){
//									if(Global.arContents[idCtt]["path"].substr(Global.arContents[idCtt]["path"].replace(/\\/g,"/").lastIndexOf("/")+1)==videoName){
//										content = Global.arContents[idCtt]["path"];
//									}
//								}
//							}
							// Now that we got the good video path, we push in the array
							ar2.push({idCtt:a[0], idGrp:a[1], idCut:a[2], idView:a[3], crit:a[3], idSeg:a[5], tIn:Number(inst.@begin), tOut:Number(inst.@end), type:curMedia.@t.toString(), v:uint(inst.@v), color:uint(curMedia.@c), content:content, idAuthor:"", author:"", idTitle:"", title:"", date:"", trId:Number(inst.@trId), trIc:Number(inst.@trIc), trOd:Number(inst.@trOd), trOc:Number(inst.@trOc)});
						}
						// And we push a new edit entry with the edit's title and abstract
						editsAr.push({id:"bab_1", title:editing.title.toString(), abstract:editing.abstract.toString(), segAr1:ar1, segAr2:ar2, creator:"projectCreator", created:now, contributor:"projectCreator", modified:now});
						titlesAr.push(editing.title.toString());
					}
					if(editsAr.length==0){
						editsAr.push({id:"bab_1", title:"Bout à bout 1", abstract:"", segAr1:new Array(), segAr2:new Array(), creator:"projectCreator", created:now, contributor:"projectCreator", modified:now});
						titlesAr.push("Bout à bout 1");
					}
					//setBab(0, true);
				}
			}
			else{
				editsAr = [{id:"bab_1", title:"Bout à bout 1", abstract:"", segAr1:new Array(), segAr2:new Array(), creator:"projectCreator", created:now, contributor:"projectCreator", modified:now}];
				titlesAr = ["Bout à bout 1"];
				//setBab(0, true);
			}
			app.youCanStart();
		}
		
		public function getEditList1():Array{
			trace("bab getEditList1");
			// For each line, 2 arrays have to be prepared. The first is the edit instructions.
			// The second is the media array (type, content -path or text-, background color)
			return getEditMediaList(0, 1);
		}
		
		private function getEditMediaList(numBab:Number, line:uint):Array{
			
			var a:Array = [];
			if(0<=numBab && numBab<editsAr.length){
				// For each line, 2 arrays have to be prepared. The first is the edit instructions.
				// The second is the media array (type, content -path or text-, background color)
				var segAr:Array = [];
				// We get the good datas function of the bab id and the line id
				if(numBab==curBab && line==1) segAr = segAr1;
				else if(numBab==curBab && line==2) segAr = segAr2;
				else if(line==1) segAr = editsAr[numBab].segAr1;
				else if(line==2) segAr = editsAr[numBab].segAr2;
				// Now we scan to segment array to build the edit list and the media list
				var nbSegs:uint = segAr.length;
				var editList:Array = [];
				var mediaList:Array = [];
				var dur:uint = 0;
				for(var i:uint=0;i<nbSegs;i++){
					var posMedia:Number = NaN;
					var nbMedia:uint = mediaList.length;
					//trace("bab1 " + i + ", " + posMedia + ", nbMedia=" + nbMedia + ", " + segAr[i].content);
					var j:uint = 0;
					while(j<nbMedia && isNaN(posMedia)){
						if(mediaList[j].type==segAr[i].type && mediaList[j].color==segAr[i].color && mediaList[j].content==segAr[i].content){
							//trace("bab1 j'ai trouvé " + segAr[i].content);
							posMedia = j;
						}
						j++;
					}
					// If the media was not already in the array, we add it
					if(isNaN(posMedia)){
						//trace("bab " + numBab + " je push " + segAr[i].content);
						//(this.parentApplication as LignesDeTempsFlex).debug.text += "\nbab " + numBab + " je push " + segAr[i].content;
						mediaList.push({ref:segAr[i].idCtt, type:segAr[i].type, color:segAr[i].color, content:segAr[i].content});
						posMedia = mediaList.length - 1;
					}
					// First we get the media position : if 
					// segAr.push({seg:s, idCtt:idCttPar, idGrp:idGrpPar, idCut:idCutPar, idView:idViewPar, crit:critPar, idSeg:idSeg, tIn:tcIn, tOut:tcOut, type:type, v:100, color:color, content:content, idAuthor:idAuthor, author:author, idTitle:idTitle, title:title, date:date, trId:trIdPar, trIc:trIcPar, trOd:trOdPar, trOc:trOcPar});
					var ref:String = segAr[i].idCtt + "|;|" + segAr[i].idGrp + "|;|" + segAr[i].idCut + "|;|" + segAr[i].idView + "|;|" + segAr[i].crit + "|;|" + segAr[i].idSeg;
					editList.push({ref:ref, m:posMedia, tIn:segAr[i].tIn, tOut:segAr[i].tOut, eIn:dur, eOut:(dur+(segAr[i].tOut-segAr[i].tIn)), v:segAr[i].v, trId:segAr[i].trId, trIc:segAr[i].trIc, trOd:segAr[i].trOd, trOc:segAr[i].trOc});
					dur += segAr[i].tOut - segAr[i].tIn;
				}
				a = [editList, mediaList];
			}
			// We return an array with the 2 array, edit list and media list
			return a;
			
		}
		
		
		
		//
		// Functions to code colors int to Hexa string RRGGBB and Hexa string to int
		//
		private function colorNbrToHexaStr(c:int):String{
			var s:String = c.toString(16);
			var nbZero:uint = 6 - s.length;
			for(var i:uint=0;i<nbZero;i++){
				s = "0" + s;
			}
			return s;
		}
		private function colorHexaStrToNbr(s:String):Number{
			var n:Number;
			if(s.substr(0,1)=="#") n = Number("0x" + s.substr(1));
			else n = Number(s);
			return n;
		}
		public function get now():String{
			var d:Date = new Date();
			var m:uint = d.month + 1; // because Date.month begins at 0
			return d.fullYear + "-" + (m<10?("0"+m):m) + "-" + (d.date<10?("0"+d.date):d.date) + "T" + (d.hours<10?("0"+d.hours):d.hours) + ":" + (d.minutes<10?("0"+d.minutes):d.minutes) + ":" + (d.seconds<10?("0"+d.seconds):d.seconds);
		}
		
	}
}