/* Shows an example of a widget, with :
 * - Use of source data
 * - Use of templating
 * - Use of internationalization
 */

import helloWorldStyles from "./HelloWorld.module.css";

const HelloWorld = function (ns) {
   return class extends ns.Widgets.Widget {
    constructor(player, config) {
      super(player,config);
      console.log(
        "Calling IriSP.Widget's constructor from IriSP.HelloWorldWidget"
      );
    }

    static defaults = {
      text: "world",
    };

    static template = `<div class="Ldt-HelloWorld"><p>{{l10n.Hello}} {{text}}</p><p>Looks like we have <span class="Ldt-HelloWorld-annotations">{{source.contents.annotation.length}} annotations</span> in this feed</p></div>`;

    static messages =  {
      fr: {
        Hello: "Bonjour,",
      },
      en: {
        Hello: "Hello,",
      },
    };

    draw = function () {
      this.renderTemplate();
      console.log("HelloWorldWidget was drawn");
    };
  };
}

export { HelloWorld, helloWorldStyles};
