/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.AbstractResourceCollectionWrapper;

public class LazyResourceCollectionWrapper
extends AbstractResourceCollectionWrapper {
    private List cachedResources = new ArrayList();
    private FilteringIterator filteringIterator;

    protected Iterator createIterator() {
        Iterator iterator;
        if (this.isCache()) {
            if (this.filteringIterator == null) {
                this.filteringIterator = new FilteringIterator(this.getResourceCollection().iterator());
            }
            iterator = new CachedIterator(this.filteringIterator);
        } else {
            iterator = new FilteringIterator(this.getResourceCollection().iterator());
        }
        return iterator;
    }

    protected int getSize() {
        Iterator it = this.createIterator();
        int size = 0;
        while (it.hasNext()) {
            it.next();
            ++size;
        }
        return size;
    }

    protected boolean filterResource(Resource r) {
        return false;
    }

    private class CachedIterator
    implements Iterator {
        int cusrsor = 0;
        private final Iterator it;

        public CachedIterator(Iterator it) {
            this.it = it;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            List list = LazyResourceCollectionWrapper.this.cachedResources;
            synchronized (list) {
                if (LazyResourceCollectionWrapper.this.cachedResources.size() > this.cusrsor) {
                    return true;
                }
                if (!this.it.hasNext()) {
                    return false;
                }
                Resource r = (Resource)this.it.next();
                LazyResourceCollectionWrapper.this.cachedResources.add(r);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            List list = LazyResourceCollectionWrapper.this.cachedResources;
            synchronized (list) {
                return LazyResourceCollectionWrapper.this.cachedResources.get(this.cusrsor++);
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class FilteringIterator
    implements Iterator {
        Resource next = null;
        boolean ended = false;
        protected final Iterator it;

        public FilteringIterator(Iterator it) {
            this.it = it;
        }

        public boolean hasNext() {
            if (this.ended) {
                return false;
            }
            while (this.next == null) {
                if (!this.it.hasNext()) {
                    this.ended = true;
                    return false;
                }
                this.next = (Resource)this.it.next();
                if (!LazyResourceCollectionWrapper.this.filterResource(this.next)) continue;
                this.next = null;
            }
            return true;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new UnsupportedOperationException();
            }
            Resource r = this.next;
            this.next = null;
            return r;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

