﻿package bab.player
{
	import fl.video.*;
	
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	
	//import mx.controls.Alert;
	
	import nl.inlet42.data.subtitles.SubTitleData;
	import nl.inlet42.data.subtitles.SubtitleParser;
    
	use namespace flvplayback_internal;
	
	public class FLVPlaybackCaptioningLDT extends FLVPlaybackCaptioning 
	{
		public function FLVPlaybackCaptioningLDT() 
		{
			super();
		}
		public function loadCapXml(capXml:XML):void{
			
            ttm = new TimedTextManager(this);
			//trace("ttm 2 = "  + ttm);
			ttm.xmlLoader = new URLLoader();
			ttm.xmlLoader.data = capXml;
			//trace("ttm.xmlLoader.data = "  + ttm.xmlLoader.data.toString());
			ttm.xmlLoadEventHandler(new Event(Event.COMPLETE));
			
        }
        
        //
        // Generates a time text xml from a srt file
        //
        public function loadSrt(urlSrt:String):void{
        	var urll:URLLoader = new URLLoader(new URLRequest(urlSrt)); 
			urll.addEventListener(Event.COMPLETE, onloadSrt);
			urll.addEventListener(IOErrorEvent.IO_ERROR, errorLoadSrt);
        }
		private function errorLoadSrt(e:IOErrorEvent):void{
			//Alert.show("Impossible to load the file " + e.text, "Error");
		}
		private function onloadSrt(e:Event):void{
			var a:Array = SubtitleParser.parseSRT(e.currentTarget.data);
			//trace("a = " + a);
			var nbSub:uint = a.length;
			default xml namespace = new Namespace("http://www.w3.org/2006/10/ttaf1");
			var subTtmXml:XML = 
			<tt xml:lang='en' xmlns='http://www.w3.org/2006/10/ttaf1' xmlns:tts='http://www.w3.org/2006/10/ttaf1#style'>
			  <head/>
			  <body>
			    <div xml:id="captions"/>
			  </body>
			</tt>;
			var divNode:XML = subTtmXml.body.div[0];
			for(var i:uint=0;i<nbSub;i++){
				var sub:SubTitleData = a[i];
				divNode.appendChild(new XML("<p begin=\"" + sub.startStr + "\" end=\"" + sub.endStr + "\"><![CDATA[<font face=\"Arial\">" + sub.text + "</font>]]></p>"));
			}
			loadCapXml(subTtmXml);
		}

	}

}