// Class AdaptivePlayer
const AdaptivePlayer = function (ns) {
  return class extends ns.Widgets.Widget {
    constructor(player, config) {
      super(player, config);
    }

    static defaults = {
      mime_type: 'video/mp4; codecs="avc1.42E01E"',
      normal_player: "HtmlPlayer",
      fallback_player: "HtmlPlayer",
    };

    draw() {
      if (typeof this.video === "undefined") {
        this.video = this.media.video;
      }

      var _props = ["autostart", "video", "height", "width", "url_transform"],
        _opts = {},
        _canPlayType = document
          .createElement("video")
          .canPlayType(this.mime_type);

      _opts.type =
        _canPlayType !== "no" ? this.normal_player : this.fallback_player;

      for (var i = 0; i < _props.length; i++) {
        if (typeof this[_props[i]] !== "undefined") {
          _opts[_props[i]] = this[_props[i]];
        }
      }

      this.insertSubwidget(this.$, _opts);
    }
  };
};
export { AdaptivePlayer };
