import { AdaptivePlayer } from "./AdaptivePlayer";
import { HelloWorld, helloWorldStyles } from "./HelloWorld";
import { Annotation, annotationStyles } from "./Annotation";
import { AnnotationsController, annotationsControllerStyles } from "./AnnotationsController";
import { AnnotationsList, annotationsListStyles } from "./AnnotationsList";
import { Arrow } from "./Arrow";
import { Controller, controllerStyles } from "./Controller";
import { CreateAnnotation, createAnnotationStyles } from "./CreateAnnotation";
import { CurrentSegmentInfobox, currentSegmentInfoboxStyles } from "./CurrentSegmentInfobox";
import { DailymotionPlayer } from "./DailymotionPlayer";
import { EnrichedPlan, enrichedPlanStyles } from "./EnrichedPlan";
import { Highlighter, highlighterStyles } from "./Highlighter";
import { HtmlMashupPlayer } from "./HtmlMashupPlayer";
import { HtmlPlayer } from "./HtmlPlayer";
import { ImageDisplay, imageDisplayStyles } from "./ImageDisplay";
import { JwpPlayer } from "./JwpPlayer";
//import { KnowledgeConcierge, knowledgeConciergeStyles } from "./KnowledgeConcierge";
import { LatestAnnotation, latestAnnotationStyles } from "./LatestAnnotation";
import { MashupPlayer, mashupPlayerStyles } from "./MashupPlayer";
import { Mediafragment } from "./Mediafragment";
import { MediaList, mediaListStyles } from "./MediaList";
import { NoteTaking, noteTakingStyles } from "./NoteTaking";
import { PlaceholderPlayer, placeholderPlayerStyles } from "./PlaceholderPlayer";
import { Polemic, polemicStyles } from "./Polemic";
import { PopcornPlayer } from "./PopcornPlayer";
import { Quiz, UniqueChoiceQuestion, MultipleChoiceQuestion, quizStyles } from "./Quiz";
import { QuizCreator, quizCreatorStyles } from "./QuizCreator";
// import { Renkan, renkanStyles } from "./Renkan";
import { Segments, segmentsStyles } from "./Segments";
import { Shortcuts, shortcutsStyles } from "./Shortcuts";
import { Slice, sliceStyles } from "./Slice";
import { SlidePreview, slidePreviewStyles } from "./SlidePreview";
import { Slider, sliderStyles } from "./Slider";
// import { Slideshare, slideshareStyles } from "./Slideshare";
import { SlideVideoPlayer, slideVideoPlayerStyles } from "./SlideVideoPlayer";
import { Social, socialStyles } from "./Social";
import { Sparkline } from "./Sparkline";
import { SpelSyncHtml } from "./SpelSyncHtml";
import { Tagcloud, tagcloudStyles } from "./Tagcloud";
import { Title } from "./Title";
import { Tooltip, tooltipStyles } from "./Tooltip";
import { Transcript, transcriptStyles } from "./Transcript";
import { Tweet, tweetStyles } from "./Tweet";
import { AutoPlayer } from "./AutoPlayer";
import { MultiSegments } from "./MultiSegments";

export default function (ns) {
  return {
    AdaptivePlayer: AdaptivePlayer(ns),
    AutoPlayer: AutoPlayer(ns),
    HelloWorld: HelloWorld(ns),
    Annotation: Annotation(ns),
    AnnotationsController: AnnotationsController(ns),
    AnnotationsList: AnnotationsList(ns),
    Arrow: Arrow(ns),
    Controller: Controller(ns),
    CreateAnnotation: CreateAnnotation(ns),
    CurrentSegmentInfobox: CurrentSegmentInfobox(ns),
    DailymotionPlayer: DailymotionPlayer(ns),
    EnrichedPlan: EnrichedPlan(ns),
    Highlighter: Highlighter(ns),
    HtmlMashupPlayer: HtmlMashupPlayer(ns),
    HtmlPlayer: HtmlPlayer(ns),
    ImageDisplay: ImageDisplay(ns),
    JwpPlayer: JwpPlayer(ns),
//    KnowledgeConcierge: KnowledgeConcierge(ns),
    LatestAnnotation: LatestAnnotation(ns),
    MashupPlayer: MashupPlayer(ns),
    Mediafragment: Mediafragment(ns),
    MediaList: MediaList(ns),
    MultiSegments: MultiSegments(ns),
    NoteTaking: NoteTaking(ns),
    PlaceholderPlayer: PlaceholderPlayer(ns),
    Polemic: Polemic(ns),
    PopcornPlayer: PopcornPlayer(ns),
    Quiz: Quiz(ns),
    UniqueChoiceQuestion: UniqueChoiceQuestion(ns),
    MultipleChoiceQuestion: MultipleChoiceQuestion(ns),
    QuizCreator: QuizCreator(ns),
//    Renkan: Renkan(ns),
    Segments: Segments(ns),
    Shortcuts: Shortcuts(ns),
    Slice: Slice(ns),
    SlidePreview: SlidePreview(ns),
    Slider: Slider(ns),
//    Slideshare: Slideshare(ns),
    SlideVideoPlayer: SlideVideoPlayer(ns),
    Social: Social(ns),
    Sparkline: Sparkline(ns),
    SpelSyncHtml: SpelSyncHtml(ns),
    Tagcloud: Tagcloud(ns),
    Title: Title(ns),
    Tooltip: Tooltip(ns),
    Transcript: Transcript(ns),
    Tweet: Tweet(ns),
    styles: {
      annotationStyles,
      helloWorldStyles,
      annotationsControllerStyles,
      annotationsListStyles,
      controllerStyles,
      createAnnotationStyles,
      currentSegmentInfoboxStyles,
      enrichedPlanStyles,
      highlighterStyles,
      imageDisplayStyles,
//      knowledgeConciergeStyles,
      latestAnnotationStyles,
      mashupPlayerStyles,
      mediaListStyles,
      noteTakingStyles,
      placeholderPlayerStyles,
      polemicStyles,
      quizStyles,
      quizCreatorStyles,
//      renkanStyles,
      segmentsStyles,
      shortcutsStyles,
      sliceStyles,
      slidePreviewStyles,
      sliderStyles,
//      slideshareStyles,
      slideVideoPlayerStyles,
      socialStyles,
      tagcloudStyles,
      tooltipStyles,
      transcriptStyles,
      tweetStyles,
    }
  };
}
