/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.shell.Global;
import org.mozilla.javascript.tools.shell.QuitAction;
import org.mozilla.javascript.tools.shell.SecurityProxy;
import org.mozilla.javascript.tools.shell.ShellContextFactory;

public class Main {
    public static ShellContextFactory shellContextFactory = new ShellContextFactory();
    public static Global global = new Global();
    protected static ToolErrorReporter errorReporter;
    protected static int exitCode;
    private static final int EXITCODE_RUNTIME_ERROR = 3;
    private static final int EXITCODE_FILE_NOT_FOUND = 4;
    static boolean processStdin;
    static Vector fileList;
    private static SecurityProxy securityImpl;

    public static void main(String[] stringArray) {
        try {
            if (Boolean.getBoolean("rhino.use_java_policy_security")) {
                Main.initJavaPolicySecuritySupport();
            }
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace(System.err);
        }
        int n = Main.exec(stringArray);
        if (n != 0) {
            System.exit(n);
        }
    }

    public static int exec(String[] stringArray) {
        errorReporter = new ToolErrorReporter(false, global.getErr());
        shellContextFactory.setErrorReporter(errorReporter);
        String[] stringArray2 = Main.processOptions(stringArray);
        if (processStdin) {
            fileList.addElement(null);
        }
        if (!Main.global.initialized) {
            global.init(shellContextFactory);
        }
        IProxy iProxy = new IProxy(1);
        iProxy.args = stringArray2;
        shellContextFactory.call(iProxy);
        return exitCode;
    }

    static void processFiles(Context context, String[] stringArray) {
        Object[] objectArray = new Object[stringArray.length];
        System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
        Scriptable scriptable = context.newArray((Scriptable)global, objectArray);
        global.defineProperty("arguments", scriptable, 2);
        for (int i = 0; i < fileList.size(); ++i) {
            Main.processSource(context, (String)fileList.elementAt(i));
        }
    }

    public static Global getGlobal() {
        return global;
    }

    public static String[] processOptions(String[] stringArray) {
        String string;
        int n = 0;
        while (true) {
            if (n == stringArray.length) {
                return new String[0];
            }
            String string2 = stringArray[n];
            if (!string2.startsWith("-")) {
                processStdin = false;
                fileList.addElement(string2);
                String[] stringArray2 = new String[stringArray.length - n - 1];
                System.arraycopy(stringArray, n + 1, stringArray2, 0, stringArray.length - n - 1);
                return stringArray2;
            }
            if (string2.equals("-version")) {
                int n2;
                if (++n == stringArray.length) {
                    string = string2;
                    break;
                }
                try {
                    n2 = Integer.parseInt(stringArray[n]);
                }
                catch (NumberFormatException numberFormatException) {
                    string = stringArray[n];
                    break;
                }
                if (!Context.isValidLanguageVersion(n2)) {
                    string = stringArray[n];
                    break;
                }
                shellContextFactory.setLanguageVersion(n2);
            } else if (string2.equals("-opt") || string2.equals("-O")) {
                int n3;
                if (++n == stringArray.length) {
                    string = string2;
                    break;
                }
                try {
                    n3 = Integer.parseInt(stringArray[n]);
                }
                catch (NumberFormatException numberFormatException) {
                    string = stringArray[n];
                    break;
                }
                if (n3 == -2) {
                    n3 = -1;
                } else if (!Context.isValidOptimizationLevel(n3)) {
                    string = stringArray[n];
                    break;
                }
                shellContextFactory.setOptimizationLevel(n3);
            } else if (string2.equals("-strict")) {
                shellContextFactory.setStrictMode(true);
                errorReporter.setIsReportingWarnings(true);
            } else if (string2.equals("-fatal-warnings")) {
                shellContextFactory.setWarningAsError(true);
            } else if (string2.equals("-e")) {
                processStdin = false;
                if (++n == stringArray.length) {
                    string = string2;
                    break;
                }
                if (!Main.global.initialized) {
                    global.init(shellContextFactory);
                }
                IProxy iProxy = new IProxy(2);
                iProxy.scriptText = stringArray[n];
                shellContextFactory.call(iProxy);
            } else if (string2.equals("-w")) {
                errorReporter.setIsReportingWarnings(true);
            } else if (string2.equals("-f")) {
                processStdin = false;
                if (++n == stringArray.length) {
                    string = string2;
                    break;
                }
                fileList.addElement(stringArray[n].equals("-") ? null : stringArray[n]);
            } else if (string2.equals("-sealedlib")) {
                global.setSealedStdLib(true);
            } else if (string2.equals("-debug")) {
                shellContextFactory.setGeneratingDebug(true);
            } else {
                if (string2.equals("-?") || string2.equals("-help")) {
                    global.getOut().println(ToolErrorReporter.getMessage("msg.shell.usage", Main.class.getName()));
                    System.exit(1);
                }
                string = string2;
                break;
            }
            ++n;
        }
        global.getOut().println(ToolErrorReporter.getMessage("msg.shell.invalid", string));
        global.getOut().println(ToolErrorReporter.getMessage("msg.shell.usage", Main.class.getName()));
        System.exit(1);
        return null;
    }

    private static void initJavaPolicySecuritySupport() {
        Throwable throwable;
        try {
            Class<?> clazz = Class.forName("org.mozilla.javascript.tools.shell.JavaPolicySecurity");
            securityImpl = (SecurityProxy)clazz.newInstance();
            SecurityController.initGlobal(securityImpl);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throwable = classNotFoundException;
        }
        catch (IllegalAccessException illegalAccessException) {
            throwable = illegalAccessException;
        }
        catch (InstantiationException instantiationException) {
            throwable = instantiationException;
        }
        catch (LinkageError linkageError) {
            throwable = linkageError;
        }
        throw Kit.initCause(new IllegalStateException("Can not load security support: " + throwable), throwable);
    }

    public static void processSource(Context context, String string) {
        if (string == null || string.equals("-")) {
            PrintStream printStream = global.getErr();
            if (string == null) {
                printStream.println(context.getImplementationVersion());
            }
            context.setOptimizationLevel(-1);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(global.getIn()));
            int n = 1;
            boolean bl = false;
            while (!bl) {
                Object object;
                String[] stringArray = global.getPrompts(context);
                if (string == null) {
                    printStream.print(stringArray[0]);
                }
                printStream.flush();
                String string2 = "";
                while (true) {
                    try {
                        object = bufferedReader.readLine();
                    }
                    catch (IOException iOException) {
                        printStream.println(iOException.toString());
                        break;
                    }
                    if (object == null) {
                        bl = true;
                        break;
                    }
                    string2 = string2 + (String)object + "\n";
                    ++n;
                    if (context.stringIsCompilableUnit(string2)) break;
                    printStream.print(stringArray[1]);
                }
                if ((object = Main.loadScriptFromSource(context, string2, "<stdin>", n, null)) == null) continue;
                Object object2 = Main.evaluateScript((Script)object, context, global);
                if (!(object2 == Context.getUndefinedValue() || object2 instanceof Function && string2.trim().startsWith("function"))) {
                    try {
                        printStream.println(Context.toString(object2));
                    }
                    catch (RhinoException rhinoException) {
                        ToolErrorReporter.reportException(context.getErrorReporter(), rhinoException);
                    }
                }
                NativeArray nativeArray = Main.global.history;
                nativeArray.put((int)nativeArray.getLength(), (Scriptable)nativeArray, (Object)string2);
            }
            printStream.println();
        } else {
            Main.processFile(context, global, string);
        }
        System.gc();
    }

    public static void processFile(Context context, Scriptable scriptable, String string) {
        if (securityImpl == null) {
            Main.processFileSecure(context, scriptable, string, null);
        } else {
            securityImpl.callProcessFileSecure(context, scriptable, string);
        }
    }

    static void processFileSecure(Context context, Scriptable scriptable, String string, Object object) {
        Script script;
        if (string.endsWith(".class")) {
            script = Main.loadCompiledScript(context, string, object);
        } else {
            String string2 = (String)Main.readFileOrUrl(string, true);
            if (string2 == null) {
                exitCode = 4;
                return;
            }
            if (string2.length() > 0 && string2.charAt(0) == '#') {
                for (int i = 1; i != string2.length(); ++i) {
                    char c = string2.charAt(i);
                    if (c != '\n' && c != '\r') continue;
                    string2 = string2.substring(i);
                    break;
                }
            }
            script = Main.loadScriptFromSource(context, string2, string, 1, object);
        }
        if (script != null) {
            Main.evaluateScript(script, context, scriptable);
        }
    }

    public static Script loadScriptFromSource(Context context, String string, String string2, int n, Object object) {
        try {
            return context.compileString(string, string2, n, object);
        }
        catch (EvaluatorException evaluatorException) {
            exitCode = 3;
        }
        catch (RhinoException rhinoException) {
            ToolErrorReporter.reportException(context.getErrorReporter(), rhinoException);
            exitCode = 3;
        }
        catch (VirtualMachineError virtualMachineError) {
            virtualMachineError.printStackTrace();
            String string3 = ToolErrorReporter.getMessage("msg.uncaughtJSException", virtualMachineError.toString());
            exitCode = 3;
            Context.reportError(string3);
        }
        return null;
    }

    private static Script loadCompiledScript(Context context, String string, Object object) {
        byte[] byArray = (byte[])Main.readFileOrUrl(string, false);
        if (byArray == null) {
            exitCode = 4;
            return null;
        }
        int n = string.lastIndexOf(47);
        n = n < 0 ? 0 : ++n;
        int n2 = string.lastIndexOf(46);
        if (n2 < n) {
            n2 = string.length();
        }
        String string2 = string.substring(n, n2);
        try {
            GeneratedClassLoader generatedClassLoader = SecurityController.createLoader(context.getApplicationClassLoader(), object);
            Class clazz = generatedClassLoader.defineClass(string2, byArray);
            generatedClassLoader.linkClass(clazz);
            if (!Script.class.isAssignableFrom(clazz)) {
                throw Context.reportRuntimeError("msg.must.implement.Script");
            }
            return (Script)clazz.newInstance();
        }
        catch (RhinoException rhinoException) {
            ToolErrorReporter.reportException(context.getErrorReporter(), rhinoException);
            exitCode = 3;
        }
        catch (IllegalAccessException illegalAccessException) {
            exitCode = 3;
            Context.reportError(illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            exitCode = 3;
            Context.reportError(instantiationException.toString());
        }
        return null;
    }

    public static Object evaluateScript(Script script, Context context, Scriptable scriptable) {
        try {
            return script.exec(context, scriptable);
        }
        catch (RhinoException rhinoException) {
            ToolErrorReporter.reportException(context.getErrorReporter(), rhinoException);
            exitCode = 3;
        }
        catch (VirtualMachineError virtualMachineError) {
            virtualMachineError.printStackTrace();
            String string = ToolErrorReporter.getMessage("msg.uncaughtJSException", virtualMachineError.toString());
            exitCode = 3;
            Context.reportError(string);
        }
        return Context.getUndefinedValue();
    }

    public static InputStream getIn() {
        return Main.getGlobal().getIn();
    }

    public static void setIn(InputStream inputStream) {
        Main.getGlobal().setIn(inputStream);
    }

    public static PrintStream getOut() {
        return Main.getGlobal().getOut();
    }

    public static void setOut(PrintStream printStream) {
        Main.getGlobal().setOut(printStream);
    }

    public static PrintStream getErr() {
        return Main.getGlobal().getErr();
    }

    public static void setErr(PrintStream printStream) {
        Main.getGlobal().setErr(printStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object readFileOrUrl(String string, boolean bl) {
        Object object;
        URL uRL = null;
        if (string.indexOf(58) >= 2) {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        InputStream inputStream = null;
        int n = 0;
        if (uRL == null) {
            object = new File(string);
            n = (int)((File)object).length();
            try {
                inputStream = new FileInputStream((File)object);
            }
            catch (IOException iOException) {
                Context.reportError(ToolErrorReporter.getMessage("msg.couldnt.open", string));
                return null;
            }
        }
        try {
            object = uRL.openConnection();
            inputStream = ((URLConnection)object).getInputStream();
            n = ((URLConnection)object).getContentLength();
            if (n > 0x100000) {
                n = -1;
            }
        }
        catch (IOException iOException) {
            Context.reportError(ToolErrorReporter.getMessage("msg.couldnt.open.url", uRL.toString(), iOException.toString()));
            return null;
        }
        if (n <= 0) {
            n = 4096;
        }
        try {
            try {
                object = Kit.readStream(inputStream, n);
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            Context.reportError(iOException.toString());
            return null;
        }
        Object object2 = !bl ? object : new String((byte[])object);
        return object2;
    }

    static {
        exitCode = 0;
        processStdin = true;
        fileList = new Vector(5);
        global.initQuitAction(new IProxy(3));
    }

    private static class IProxy
    implements ContextAction,
    QuitAction {
        private static final int PROCESS_FILES = 1;
        private static final int EVAL_INLINE_SCRIPT = 2;
        private static final int SYSTEM_EXIT = 3;
        private int type;
        String[] args;
        String scriptText;

        IProxy(int n) {
            this.type = n;
        }

        public Object run(Context context) {
            if (this.type == 1) {
                Main.processFiles(context, this.args);
            } else if (this.type == 2) {
                Script script = Main.loadScriptFromSource(context, this.scriptText, "<command>", 1, null);
                if (script != null) {
                    Main.evaluateScript(script, context, Main.getGlobal());
                }
            } else {
                throw Kit.codeBug();
            }
            return null;
        }

        public void quit(Context context, int n) {
            if (this.type == 3) {
                System.exit(n);
                return;
            }
            throw Kit.codeBug();
        }
    }
}

