/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.DynamicConfigurator;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.XSLTLiaison;
import org.apache.tools.ant.taskdefs.XSLTLiaison2;
import org.apache.tools.ant.taskdefs.XSLTLiaison3;
import org.apache.tools.ant.taskdefs.XSLTLogger;
import org.apache.tools.ant.taskdefs.XSLTLoggerAware;
import org.apache.tools.ant.taskdefs.optional.TraXLiaison;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.XMLCatalog;
import org.apache.tools.ant.types.resources.FileProvider;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Resources;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.ResourceUtils;

public class XSLTProcess
extends MatchingTask
implements XSLTLogger {
    private File destDir = null;
    private File baseDir = null;
    private String xslFile = null;
    private Resource xslResource = null;
    private String targetExtension = ".html";
    private String fileNameParameter = null;
    private String fileDirParameter = null;
    private Vector params = new Vector();
    private File inFile = null;
    private File outFile = null;
    private String processor;
    private Path classpath = null;
    private XSLTLiaison liaison;
    private boolean stylesheetLoaded = false;
    private boolean force = false;
    private Vector outputProperties = new Vector();
    private XMLCatalog xmlCatalog = new XMLCatalog();
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private boolean performDirectoryScan = true;
    private Factory factory = null;
    private boolean reuseLoadedStylesheet = true;
    private AntClassLoader loader = null;
    private Mapper mapperElement = null;
    private Union resources = new Union();
    private boolean useImplicitFileset = true;
    public static final String PROCESSOR_TRAX = "trax";
    private boolean suppressWarnings = false;
    private boolean failOnTransformationError = true;
    private boolean failOnError = true;
    private boolean failOnNoResources = true;
    private CommandlineJava.SysProperties sysProperties = new CommandlineJava.SysProperties();
    private TraceConfiguration traceConfiguration;

    public void setScanIncludedDirectories(boolean b) {
        this.performDirectoryScan = b;
    }

    public void setReloadStylesheet(boolean b) {
        this.reuseLoadedStylesheet = !b;
    }

    public void addMapper(Mapper mapper) {
        if (this.mapperElement != null) {
            this.handleError("Cannot define more than one mapper");
        } else {
            this.mapperElement = mapper;
        }
    }

    public void add(ResourceCollection rc) {
        this.resources.add(rc);
    }

    public void addConfiguredStyle(Resources rc) {
        if (rc.size() != 1) {
            this.handleError("The style element must be specified with exactly one nested resource.");
        } else {
            this.setXslResource((Resource)rc.iterator().next());
        }
    }

    public void setXslResource(Resource xslResource) {
        this.xslResource = xslResource;
    }

    public void add(FileNameMapper fileNameMapper) throws BuildException {
        Mapper mapper = new Mapper(this.getProject());
        mapper.add(fileNameMapper);
        this.addMapper(mapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        File savedBaseDir;
        block35: {
            block34: {
                block33: {
                    block31: {
                        block32: {
                            if ("style".equals(this.getTaskType())) {
                                this.log("Warning: the task name <style> is deprecated. Use <xslt> instead.", 1);
                            }
                            savedBaseDir = this.baseDir;
                            String baseMessage = "specify the stylesheet either as a filename in style attribute or as a nested resource";
                            if (this.xslResource == null && this.xslFile == null) {
                                this.handleError(baseMessage);
                                return;
                            }
                            if (this.xslResource != null && this.xslFile != null) {
                                this.handleError(baseMessage + " but not as both");
                                return;
                            }
                            if (this.inFile != null && !this.inFile.exists()) {
                                this.handleError("input file " + this.inFile + " does not exist");
                                return;
                            }
                            try {
                                Resource styleResource;
                                this.setupLoader();
                                if (this.sysProperties.size() > 0) {
                                    this.sysProperties.setSystem();
                                }
                                if (this.baseDir == null) {
                                    this.baseDir = this.getProject().getBaseDir();
                                }
                                this.liaison = this.getLiaison();
                                if (this.liaison instanceof XSLTLoggerAware) {
                                    ((XSLTLoggerAware)((Object)this.liaison)).setLogger(this);
                                }
                                this.log("Using " + this.liaison.getClass().toString(), 3);
                                if (this.xslFile != null) {
                                    File stylesheet = this.getProject().resolveFile(this.xslFile);
                                    if (!stylesheet.exists() && (stylesheet = FILE_UTILS.resolveFile(this.baseDir, this.xslFile)).exists()) {
                                        this.log("DEPRECATED - the 'style' attribute should be relative to the project's");
                                        this.log("             basedir, not the tasks's basedir.");
                                    }
                                    FileResource fr = new FileResource();
                                    fr.setProject(this.getProject());
                                    fr.setFile(stylesheet);
                                    styleResource = fr;
                                } else {
                                    styleResource = this.xslResource;
                                }
                                if (!styleResource.isExists()) {
                                    this.handleError("stylesheet " + styleResource + " doesn't exist.");
                                    Object var10_8 = null;
                                    if (this.loader != null) {
                                        this.loader.resetThreadContextLoader();
                                        this.loader.cleanup();
                                        this.loader = null;
                                    }
                                    if (this.sysProperties.size() <= 0) break block31;
                                    break block32;
                                }
                                if (this.inFile != null && this.outFile != null) {
                                    this.process(this.inFile, this.outFile, styleResource);
                                    break block33;
                                }
                                this.checkDest();
                                if (this.useImplicitFileset) {
                                    DirectoryScanner scanner = this.getDirectoryScanner(this.baseDir);
                                    this.log("Transforming into " + this.destDir, 2);
                                    String[] list = scanner.getIncludedFiles();
                                    for (int i = 0; i < list.length; ++i) {
                                        this.process(this.baseDir, list[i], this.destDir, styleResource);
                                    }
                                    if (this.performDirectoryScan) {
                                        String[] dirs = scanner.getIncludedDirectories();
                                        for (int j = 0; j < dirs.length; ++j) {
                                            list = new File(this.baseDir, dirs[j]).list();
                                            for (int i = 0; i < list.length; ++i) {
                                                this.process(this.baseDir, dirs[j] + File.separator + list[i], this.destDir, styleResource);
                                            }
                                        }
                                    }
                                } else if (this.resources.size() == 0) {
                                    if (this.failOnNoResources) {
                                        this.handleError("no resources specified");
                                    }
                                    break block34;
                                }
                                this.processResources(styleResource);
                                break block35;
                            }
                            catch (Throwable throwable) {
                                Object var10_12 = null;
                                if (this.loader != null) {
                                    this.loader.resetThreadContextLoader();
                                    this.loader.cleanup();
                                    this.loader = null;
                                }
                                if (this.sysProperties.size() > 0) {
                                    this.sysProperties.restoreSystem();
                                }
                                this.liaison = null;
                                this.stylesheetLoaded = false;
                                this.baseDir = savedBaseDir;
                                throw throwable;
                            }
                        }
                        this.sysProperties.restoreSystem();
                    }
                    this.liaison = null;
                    this.stylesheetLoaded = false;
                    this.baseDir = savedBaseDir;
                    return;
                }
                Object var10_9 = null;
                if (this.loader != null) {
                    this.loader.resetThreadContextLoader();
                    this.loader.cleanup();
                    this.loader = null;
                }
                if (this.sysProperties.size() > 0) {
                    this.sysProperties.restoreSystem();
                }
                this.liaison = null;
                this.stylesheetLoaded = false;
                this.baseDir = savedBaseDir;
                return;
            }
            Object var10_10 = null;
            if (this.loader != null) {
                this.loader.resetThreadContextLoader();
                this.loader.cleanup();
                this.loader = null;
            }
            if (this.sysProperties.size() > 0) {
                this.sysProperties.restoreSystem();
            }
            this.liaison = null;
            this.stylesheetLoaded = false;
            this.baseDir = savedBaseDir;
            return;
        }
        Object var10_11 = null;
        if (this.loader != null) {
            this.loader.resetThreadContextLoader();
            this.loader.cleanup();
            this.loader = null;
        }
        if (this.sysProperties.size() > 0) {
            this.sysProperties.restoreSystem();
        }
        this.liaison = null;
        this.stylesheetLoaded = false;
        this.baseDir = savedBaseDir;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setBasedir(File dir) {
        this.baseDir = dir;
    }

    public void setDestdir(File dir) {
        this.destDir = dir;
    }

    public void setExtension(String name) {
        this.targetExtension = name;
    }

    public void setStyle(String xslFile) {
        this.xslFile = xslFile;
    }

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setProcessor(String processor) {
        this.processor = processor;
    }

    public void setUseImplicitFileset(boolean useimplicitfileset) {
        this.useImplicitFileset = useimplicitfileset;
    }

    public void addConfiguredXMLCatalog(XMLCatalog xmlCatalog) {
        this.xmlCatalog.addConfiguredXMLCatalog(xmlCatalog);
    }

    public void setFileNameParameter(String fileNameParameter) {
        this.fileNameParameter = fileNameParameter;
    }

    public void setFileDirParameter(String fileDirParameter) {
        this.fileDirParameter = fileDirParameter;
    }

    public void setSuppressWarnings(boolean b) {
        this.suppressWarnings = b;
    }

    public boolean getSuppressWarnings() {
        return this.suppressWarnings;
    }

    public void setFailOnTransformationError(boolean b) {
        this.failOnTransformationError = b;
    }

    public void setFailOnError(boolean b) {
        this.failOnError = b;
    }

    public void setFailOnNoResources(boolean b) {
        this.failOnNoResources = b;
    }

    public void addSysproperty(Environment.Variable sysp) {
        this.sysProperties.addVariable(sysp);
    }

    public void addSyspropertyset(PropertySet sysp) {
        this.sysProperties.addSyspropertyset(sysp);
    }

    public TraceConfiguration createTrace() {
        if (this.traceConfiguration != null) {
            throw new BuildException("can't have more than one trace configuration");
        }
        this.traceConfiguration = new TraceConfiguration();
        return this.traceConfiguration;
    }

    public TraceConfiguration getTraceConfiguration() {
        return this.traceConfiguration;
    }

    private void resolveProcessor(String proc) throws Exception {
        if (proc.equals(PROCESSOR_TRAX)) {
            this.liaison = new TraXLiaison();
        } else {
            Class clazz = this.loadClass(proc);
            this.liaison = (XSLTLiaison)clazz.newInstance();
        }
    }

    private Class loadClass(String classname) throws Exception {
        this.setupLoader();
        if (this.loader == null) {
            return Class.forName(classname);
        }
        return Class.forName(classname, true, this.loader);
    }

    private void setupLoader() {
        if (this.classpath != null && this.loader == null) {
            this.loader = this.getProject().createClassLoader(this.classpath);
            this.loader.setThreadContextLoader();
        }
    }

    public void setOut(File outFile) {
        this.outFile = outFile;
    }

    public void setIn(File inFile) {
        this.inFile = inFile;
    }

    private void checkDest() {
        if (this.destDir == null) {
            this.handleError("destdir attributes must be set!");
        }
    }

    private void processResources(Resource stylesheet) {
        Iterator iter = this.resources.iterator();
        while (iter.hasNext()) {
            FileResource f;
            Resource r = (Resource)iter.next();
            if (!r.isExists()) continue;
            File base = this.baseDir;
            String name = r.getName();
            FileProvider fp = (FileProvider)r.as(class$org$apache$tools$ant$types$resources$FileProvider == null ? XSLTProcess.class$("org.apache.tools.ant.types.resources.FileProvider") : class$org$apache$tools$ant$types$resources$FileProvider);
            if (fp != null && (base = (f = ResourceUtils.asFileResource(fp)).getBaseDir()) == null) {
                name = f.getFile().getAbsolutePath();
            }
            this.process(base, name, this.destDir, stylesheet);
        }
    }

    private void process(File baseDir, String xmlFile, File destDir, Resource stylesheet) throws BuildException {
        File outF = null;
        File inF = null;
        try {
            long styleSheetLastModified = stylesheet.getLastModified();
            inF = new File(baseDir, xmlFile);
            if (inF.isDirectory()) {
                this.log("Skipping " + inF + " it is a directory.", 3);
                return;
            }
            FileNameMapper mapper = null;
            mapper = this.mapperElement != null ? this.mapperElement.getImplementation() : new StyleMapper();
            String[] outFileName = mapper.mapFileName(xmlFile);
            if (outFileName == null || outFileName.length == 0) {
                this.log("Skipping " + this.inFile + " it cannot get mapped to output.", 3);
                return;
            }
            if (outFileName == null || outFileName.length > 1) {
                this.log("Skipping " + this.inFile + " its mapping is ambiguos.", 3);
                return;
            }
            outF = new File(destDir, outFileName[0]);
            if (this.force || inF.lastModified() > outF.lastModified() || styleSheetLastModified > outF.lastModified()) {
                this.ensureDirectoryFor(outF);
                this.log("Processing " + inF + " to " + outF);
                this.configureLiaison(stylesheet);
                this.setLiaisonDynamicFileParameters(this.liaison, inF);
                this.liaison.transform(inF, outF);
            }
        }
        catch (Exception ex) {
            this.log("Failed to process " + this.inFile, 2);
            if (outF != null) {
                outF.delete();
            }
            this.handleTransformationError(ex);
        }
    }

    private void process(File inFile, File outFile, Resource stylesheet) throws BuildException {
        try {
            long styleSheetLastModified = stylesheet.getLastModified();
            this.log("In file " + inFile + " time: " + inFile.lastModified(), 4);
            this.log("Out file " + outFile + " time: " + outFile.lastModified(), 4);
            this.log("Style file " + this.xslFile + " time: " + styleSheetLastModified, 4);
            if (this.force || inFile.lastModified() >= outFile.lastModified() || styleSheetLastModified >= outFile.lastModified()) {
                this.ensureDirectoryFor(outFile);
                this.log("Processing " + inFile + " to " + outFile, 2);
                this.configureLiaison(stylesheet);
                this.setLiaisonDynamicFileParameters(this.liaison, inFile);
                this.liaison.transform(inFile, outFile);
            } else {
                this.log("Skipping input file " + inFile + " because it is older than output file " + outFile + " and so is the stylesheet " + stylesheet, 4);
            }
        }
        catch (Exception ex) {
            this.log("Failed to process " + inFile, 2);
            if (outFile != null) {
                outFile.delete();
            }
            this.handleTransformationError(ex);
        }
    }

    private void ensureDirectoryFor(File targetFile) throws BuildException {
        File directory = targetFile.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            this.handleError("Unable to create directory: " + directory.getAbsolutePath());
        }
    }

    public Factory getFactory() {
        return this.factory;
    }

    public XMLCatalog getXMLCatalog() {
        this.xmlCatalog.setProject(this.getProject());
        return this.xmlCatalog;
    }

    public Enumeration getOutputProperties() {
        return this.outputProperties.elements();
    }

    protected XSLTLiaison getLiaison() {
        if (this.liaison == null) {
            if (this.processor != null) {
                try {
                    this.resolveProcessor(this.processor);
                }
                catch (Exception e) {
                    this.handleError(e);
                }
            } else {
                try {
                    this.resolveProcessor(PROCESSOR_TRAX);
                }
                catch (Throwable e1) {
                    e1.printStackTrace();
                    this.handleError(e1);
                }
            }
        }
        return this.liaison;
    }

    public Param createParam() {
        Param p = new Param();
        this.params.addElement(p);
        return p;
    }

    public OutputProperty createOutputProperty() {
        OutputProperty p = new OutputProperty();
        this.outputProperties.addElement(p);
        return p;
    }

    public void init() throws BuildException {
        super.init();
        this.xmlCatalog.setProject(this.getProject());
    }

    protected void configureLiaison(File stylesheet) throws BuildException {
        FileResource fr = new FileResource();
        fr.setProject(this.getProject());
        fr.setFile(stylesheet);
        this.configureLiaison(fr);
    }

    protected void configureLiaison(Resource stylesheet) throws BuildException {
        if (this.stylesheetLoaded && this.reuseLoadedStylesheet) {
            return;
        }
        this.stylesheetLoaded = true;
        try {
            this.log("Loading stylesheet " + stylesheet, 2);
            if (this.liaison instanceof XSLTLiaison2) {
                ((XSLTLiaison2)this.liaison).configure(this);
            }
            if (this.liaison instanceof XSLTLiaison3) {
                ((XSLTLiaison3)this.liaison).setStylesheet(stylesheet);
            } else {
                FileProvider fp = (FileProvider)stylesheet.as(FileProvider.class);
                if (fp != null) {
                    this.liaison.setStylesheet(fp.getFile());
                } else {
                    this.handleError(this.liaison.getClass().toString() + " accepts the stylesheet only as a file");
                    return;
                }
            }
            Enumeration e = this.params.elements();
            while (e.hasMoreElements()) {
                Param p = (Param)e.nextElement();
                if (!p.shouldUse()) continue;
                this.liaison.addParam(p.getName(), p.getExpression());
            }
        }
        catch (Exception ex) {
            this.log("Failed to transform using stylesheet " + stylesheet, 2);
            this.handleTransformationError(ex);
        }
    }

    private void setLiaisonDynamicFileParameters(XSLTLiaison liaison, File inFile) throws Exception {
        if (this.fileNameParameter != null) {
            liaison.addParam(this.fileNameParameter, inFile.getName());
        }
        if (this.fileDirParameter != null) {
            String fileName = FileUtils.getRelativePath(this.baseDir, inFile);
            File file = new File(fileName);
            liaison.addParam(this.fileDirParameter, file.getParent() != null ? file.getParent().replace('\\', '/') : ".");
        }
    }

    public Factory createFactory() throws BuildException {
        if (this.factory != null) {
            this.handleError("'factory' element must be unique");
        } else {
            this.factory = new Factory();
        }
        return this.factory;
    }

    protected void handleError(String msg) {
        if (this.failOnError) {
            throw new BuildException(msg, this.getLocation());
        }
        this.log(msg, 1);
    }

    protected void handleError(Throwable ex) {
        if (this.failOnError) {
            throw new BuildException(ex);
        }
        this.log("Caught an exception: " + ex, 1);
    }

    protected void handleTransformationError(Exception ex) {
        if (this.failOnError && this.failOnTransformationError) {
            throw new BuildException(ex);
        }
        this.log("Caught an error during transformation: " + ex, 1);
    }

    public final class TraceConfiguration {
        private boolean elements;
        private boolean extension;
        private boolean generation;
        private boolean selection;
        private boolean templates;

        public void setElements(boolean b) {
            this.elements = b;
        }

        public boolean getElements() {
            return this.elements;
        }

        public void setExtension(boolean b) {
            this.extension = b;
        }

        public boolean getExtension() {
            return this.extension;
        }

        public void setGeneration(boolean b) {
            this.generation = b;
        }

        public boolean getGeneration() {
            return this.generation;
        }

        public void setSelection(boolean b) {
            this.selection = b;
        }

        public boolean getSelection() {
            return this.selection;
        }

        public void setTemplates(boolean b) {
            this.templates = b;
        }

        public boolean getTemplates() {
            return this.templates;
        }

        public OutputStream getOutputStream() {
            return new LogOutputStream(XSLTProcess.this);
        }
    }

    private class StyleMapper
    implements FileNameMapper {
        private StyleMapper() {
        }

        public void setFrom(String from) {
        }

        public void setTo(String to) {
        }

        public String[] mapFileName(String xmlFile) {
            int dotPos = xmlFile.lastIndexOf(46);
            if (dotPos > 0) {
                xmlFile = xmlFile.substring(0, dotPos);
            }
            return new String[]{xmlFile + XSLTProcess.this.targetExtension};
        }
    }

    public static class Factory {
        private String name;
        private Vector attributes = new Vector();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void addAttribute(Attribute attr) {
            this.attributes.addElement(attr);
        }

        public Enumeration getAttributes() {
            return this.attributes.elements();
        }

        public static class Attribute
        implements DynamicConfigurator {
            private String name;
            private Object value;

            public String getName() {
                return this.name;
            }

            public Object getValue() {
                return this.value;
            }

            public Object createDynamicElement(String name) throws BuildException {
                return null;
            }

            public void setDynamicAttribute(String name, String value) throws BuildException {
                if ("name".equalsIgnoreCase(name)) {
                    this.name = value;
                } else if ("value".equalsIgnoreCase(name)) {
                    if ("true".equalsIgnoreCase(value)) {
                        this.value = Boolean.TRUE;
                    } else if ("false".equalsIgnoreCase(value)) {
                        this.value = Boolean.FALSE;
                    } else {
                        try {
                            this.value = new Integer(value);
                        }
                        catch (NumberFormatException e) {
                            this.value = value;
                        }
                    }
                } else {
                    throw new BuildException("Unsupported attribute: " + name);
                }
            }
        }
    }

    public static class OutputProperty {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class Param {
        private String name = null;
        private String expression = null;
        private Object ifCond;
        private Object unlessCond;
        private Project project;

        public void setProject(Project project) {
            this.project = project;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }

        public String getName() throws BuildException {
            if (this.name == null) {
                throw new BuildException("Name attribute is missing.");
            }
            return this.name;
        }

        public String getExpression() throws BuildException {
            if (this.expression == null) {
                throw new BuildException("Expression attribute is missing.");
            }
            return this.expression;
        }

        public void setIf(Object ifCond) {
            this.ifCond = ifCond;
        }

        public void setIf(String ifProperty) {
            this.setIf((Object)ifProperty);
        }

        public void setUnless(Object unlessCond) {
            this.unlessCond = unlessCond;
        }

        public void setUnless(String unlessProperty) {
            this.setUnless((Object)unlessProperty);
        }

        public boolean shouldUse() {
            PropertyHelper ph = PropertyHelper.getPropertyHelper(this.project);
            return ph.testIfCondition(this.ifCond) && ph.testUnlessCondition(this.unlessCond);
        }
    }
}

