import { VideojsPlayer } from "../../widgets/VideojsPlayer";

/* Start of defaults.js */
export default function (IriSP) {

  const defaults = {};

  defaults.language = "en";


  defaults.widgetsDir = "widgets";

  defaults.widgetsRequirements = {
    PopcornPlayer: {
      noCss: true,
      requires: ["popcorn"],
    },
    HtmlPlayer: {
      noCss: true,
    },
    JwpPlayer: {
      noCss: true,
      requires: ["jwplayer"],
    },
    DailymotionPlayer: {
      noCss: true,
      requires: ["swfObject"],
    },
    AdaptivePlayer: {
      noCss: true,
    },
    AutoPlayer: {
      noCss: true,
    },
    AnnotationsList: {
      requires: ["jwplayer"],
    },
    Sparkline: {
      noCss: true,
      requires: ["raphael"],
    },
    Arrow: {
      noCss: true,
      requires: ["raphael"],
    },
    Mediafragment: {
      noCss: true,
    },
    Trace: {
      noCss: true,
      requires: ["tracemanager"],
    },
    Slideshare: {
      requires: ["swfObject"],
    },
    Social: {
      requires: ["zeroClipboardJs"],
    },
    Renkan: {
      requires: [
        "backbone",
        "backboneRelational",
        "paper",
        "jqueryMousewheel",
        "renkanPublish",
      ],
    },
    KnowledgeConcierge: {
      requires: ["processing"],
    },
    MultiSegments: {
      noCss: true,
    },
    SlideVideoPlayer: {
      requires: ["jQuery", "jQueryUI", "splitter"],
    },
    Shortcuts: {
      requires: ["mousetrap", "mousetrapGlobal"],
    },
    VideojsPlayer: {
      requires: ["videojs", "videojs-youtube", "videojs-vimeo"]
    }
  };

  defaults.guiDefaults = {
    width: 640,
    container: "LdtPlayer",
    spacer_div_height: 0,
    widgets: [],
  };

  return defaults;
};

/* End of defaults.js */
