const SpelSyncHtml = function(ns) {
    return class extends ns.Widgets.Widget {
        constructor(player, config) {
            super(player, config);
    console.log("Calling IriSP.Widget's constructor from IriSP.HelloWorldWidget");
};

static defaults = {
    src: "about:blank"
};

static template =
    '<div class="Ldt-SpelSyncHtml"><iframe src="{{src}}" {{#width}}width="{{width}}"{{/width}} {{#height}}height="{{height}}"{{/height}}</div>';

draw() {
    this.renderTemplate();
    var frame = this.$.find("iframe")[0],
        basesrc = this.src.replace(/#.*$/,'');
    this.getWidgetAnnotations().forEach(function(a) {
        a.on("enter", function() {
            if (a.content && a.content.data && a.content.data.ref_text) {
                frame.src = basesrc + '#' + a.content.data.ref_text;
            }
        });
    });
};
    }}

export { SpelSyncHtml };