/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util.depend;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipFile;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.VectorSet;
import org.apache.tools.ant.util.depend.DependencyAnalyzer;

public abstract class AbstractAnalyzer
implements DependencyAnalyzer {
    public static final int MAX_LOOPS = 1000;
    private Path sourcePath = new Path(null);
    private Path classPath = new Path(null);
    private final Vector rootClasses = new VectorSet();
    private boolean determined = false;
    private Vector fileDependencies;
    private Vector classDependencies;
    private boolean closure = true;

    protected AbstractAnalyzer() {
        this.reset();
    }

    public void setClosure(boolean closure) {
        this.closure = closure;
    }

    public Enumeration getFileDependencies() {
        if (!this.supportsFileDependencies()) {
            throw new RuntimeException("File dependencies are not supported by this analyzer");
        }
        if (!this.determined) {
            this.determineDependencies(this.fileDependencies, this.classDependencies);
        }
        return this.fileDependencies.elements();
    }

    public Enumeration getClassDependencies() {
        if (!this.determined) {
            this.determineDependencies(this.fileDependencies, this.classDependencies);
        }
        return this.classDependencies.elements();
    }

    public File getClassContainer(String classname) throws IOException {
        String classLocation = classname.replace('.', '/') + ".class";
        return this.getResourceContainer(classLocation, this.classPath.list());
    }

    public File getSourceContainer(String classname) throws IOException {
        String sourceLocation = classname.replace('.', '/') + ".java";
        return this.getResourceContainer(sourceLocation, this.sourcePath.list());
    }

    public void addSourcePath(Path sourcePath) {
        if (sourcePath == null) {
            return;
        }
        this.sourcePath.append(sourcePath);
        this.sourcePath.setProject(sourcePath.getProject());
    }

    public void addClassPath(Path classPath) {
        if (classPath == null) {
            return;
        }
        this.classPath.append(classPath);
        this.classPath.setProject(classPath.getProject());
    }

    public void addRootClass(String className) {
        if (className == null) {
            return;
        }
        if (!this.rootClasses.contains(className)) {
            this.rootClasses.addElement(className);
        }
    }

    public void config(String name, Object info) {
    }

    public void reset() {
        this.rootClasses.removeAllElements();
        this.determined = false;
        this.fileDependencies = new Vector();
        this.classDependencies = new Vector();
    }

    protected Enumeration getRootClasses() {
        return this.rootClasses.elements();
    }

    protected boolean isClosureRequired() {
        return this.closure;
    }

    protected abstract void determineDependencies(Vector var1, Vector var2);

    protected abstract boolean supportsFileDependencies();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getResourceContainer(String resourceLocation, String[] paths) throws IOException {
        for (int i = 0; i < paths.length; ++i) {
            File element = new File(paths[i]);
            if (!element.exists()) continue;
            if (element.isDirectory()) {
                File resource = new File(element, resourceLocation);
                if (!resource.exists()) continue;
                return resource;
            }
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(element);
                if (zipFile.getEntry(resourceLocation) == null) continue;
                File file = element;
                return file;
            }
            finally {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
        }
        return null;
    }
}

